% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitilde_by_chain.R
\name{pitilde_by_chain}
\alias{pitilde_by_chain}
\title{Compute the Mean Conditional Probability of Second-Stage Correct Classification, by First-Stage and True Outcome Across all Subjects for each MCMC Chain}
\usage{
pitilde_by_chain(n_chains, chains_list, V, n, n_cat)
}
\arguments{
\item{n_chains}{An integer specifying the number of MCMC chains to compute over.}

\item{chains_list}{A numeric list containing the samples from \code{n_chains}
MCMC chains.}

\item{V}{A numeric design matrix.}

\item{n}{An integer value specifying the number of observations in the sample.
This value should be equal to the number of rows of the design matrix, \code{V}.}

\item{n_cat}{The number of categorical values that the true outcome, \eqn{Y},
the first-stage observed outcome, \eqn{Y*}, and the second-stage
observed outcome, \eqn{\tilde{Y}}, can take.}
}
\value{
\code{pitilde_by_chain} returns a numeric matrix of the average
conditional probability \eqn{P( \tilde{Y} = j | Y^* = j, Y = j, V)} across all subjects for
each MCMC chain. Rows of the matrix correspond to MCMC chains, up to \code{n_chains}.
The first column contains the conditional probability \eqn{P( \tilde{Y} = 1 | Y^* = 1, Y = 1, V)}.
The second column contains the conditional probability \eqn{P( \tilde{Y} = 2 | Y^* = 2, Y = 2, V)}.
}
\description{
Compute the Mean Conditional Probability of Second-Stage Correct Classification, by First-Stage and True Outcome Across all Subjects for each MCMC Chain
}
