% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_and_get.R
\name{get_dset.coin}
\alias{get_dset.coin}
\title{Gets a named data set and performs checks}
\usage{
\method{get_dset}{coin}(x, dset, also_get = NULL, ...)
}
\arguments{
\item{x}{A coin class object}

\item{dset}{A character string corresponding to a named data set within \code{.$Data}. E.g. \code{"Raw"}.}

\item{also_get}{A character vector specifying any columns to attach to the data set that are \emph{not}
indicators or aggregates. These will be e.g. \code{uName}, groups, denominators or columns labelled as "Other"
in \code{iMeta}. These columns are stored in \code{.$Meta$Unit} to avoid repetition. Set \code{also_get = "all"} to
attach all columns, or set \code{also_get = "none"} to return only numeric columns, i.e. no \code{uCode} column.}

\item{...}{arguments passed to or from other methods.}
}
\value{
Data frame of indicator data.
}
\description{
A helper function to retrieve a named data set from the coin object. Also performs input checks at the
same time.
}
\details{
If \code{also_get} is not specified, this will return the indicator columns with the \code{uCode} identifiers
in the first column. Optionally, \code{also_get} can be specified to attach other metadata columns, or
to only return the numeric (indicator) columns with no identifiers. This latter option might be useful
for e.g. examining correlations.
}
\examples{
# build example coin, just up to raw dset for speed
coin <- build_example_coin(up_to = "new_coin", quietly = TRUE)

# retrieve raw data set with added cols
get_dset(coin, dset = "Raw", also_get = c("uName", "GDP_group"))

}
