% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcVecLMs.R
\name{calcVecLMs}
\alias{calcVecLMs}
\title{Create a linear regression matrix.}
\usage{
calcVecLMs(bin_data, use_slurm = F, job_finished = F, slurmjob = NULL,
  n_nodes = NULL, cpus_on_each_node = 2, memory_per_node = "2g",
  walltime = "4:00:00")
}
\arguments{
\item{bin_data}{The parent matrix, with columns to have linear regression performed on them.}

\item{use_slurm}{Paralleize over a number of slurm HPC jobs? If false, the program will simply run locally.}

\item{job_finished}{Are all the slurm jobs finished and the results need retrieving?}

\item{slurmjob}{the slurm job object produced by rslurm::slurm_apply(), after running the function initially.}

\item{n_nodes}{the number of nodes used in your slurm job.}

\item{cpus_on_each_node}{The number of cpus used on each node}

\item{memory_per_node}{the amount of ram per node (e.g. "32g" or "2g")}

\item{walltime}{Time for job to be completed for SLURM scheduler in hh:mm:ss format. Defaults to 4h.}
}
\value{
The output matrix, or if using slurm, the slurm job object (which should be saved as an rds file and reloaded when creating the output matrix).
}
\description{
Creates a matrix of linear regression p-values, log transformed from every combination of columns in the parent matrix.
}
\examples{

#small example
#bin_data<-matrix(runif(5*5),ncol=5)
foreach::registerDoSEQ()
#full_matrix<-suppressWarnings(calcVecLMs(bin_data))
#Please note that lm() will make a warning when there are two vectors that are too close 
#numerically (this will always happen along the diagonal).
#This is normal behavior and is controlled & accounted for using this function as well as
#the postProcessLinRegMatrix function (which converts the infinite values to a maximum).

}
\keyword{linear}
\keyword{lm}
\keyword{matrix}
\keyword{regression}
