% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_lv_switchgear_and_other.R
\name{safety_cof_lv_switchgear_and_other}
\alias{safety_cof_lv_switchgear_and_other}
\title{Safety cost of Failure for LV swicthgear and others}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
safety_cof_lv_switchgear_and_other(lv_asset_category, location_risk, type_risk)
}
\arguments{
\item{lv_asset_category}{String The type of LV asset category
Options: \code{lv_asset_category = c("LV Board (WM)",
"LV Board (X-type Network) (WM)", "LV Circuit Breaker",
"LV Pillar (ID)", "LV Pillar (OD at Substation)", "LV Pillar (OD not at a Substation)")}}

\item{location_risk}{String Type Financial factor criteria for LV switchgear
(cf. section D1.2.1, page 178, CNAIM, 2021).
Options: \code{location_risk = c("Low", "Medium", "High")}.
The default setting is
\code{location_risk = "Medium"}.}

\item{type_risk}{String. Asses Financial factor criteria for LV switchgear
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{type_risk = c("Low", "Medium", "High")}.
The default setting is
\code{type_risk = "Medium"}.}
}
\value{
Numeric. Financial consequences of failure for LV switchgear
}
\description{
This function calculates safety consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Safetyr consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
safety_cof_lv_switchgear_and_other(lv_asset_category = "LV Board (WM)",
location_risk = "Default",
type_risk = "Default")
}
