% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pof_transformer_11_20kv.R
\name{pof_transformer_11_20kv}
\alias{pof_transformer_11_20kv}
\title{Current Probability of Failure for 6.6/11kV and 20kV Transformers}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
pof_transformer_11_20kv(
  hv_transformer_type = "6.6/11kV Transformer (GM)",
  utilisation_pct = "Default",
  placement = "Default",
  altitude_m = "Default",
  distance_from_coast_km = "Default",
  corrosion_category_index = "Default",
  age,
  partial_discharge = "Default",
  temperature_reading = "Default",
  observed_condition = "Default",
  reliability_factor = "Default",
  moisture = "Default",
  oil_acidity = "Default",
  bd_strength = "Default"
)
}
\arguments{
\item{hv_transformer_type}{String. Refers to the high voltage transformer
type the calculation is done for. Options: \code{hv_transformer_type =
c("6.6/11kV Transformer (GM)", "20kV Transformer (GM)")}. The default setting
is \code{hv_transformer_type = 6.6/11kV Transformer (GM)}.}

\item{utilisation_pct}{Numeric. The max percentage of utilisation
under normal operating conditions.}

\item{placement}{String. Specify if the asset is located outdoor or indoor.
A setting of \code{"Outdoor"} means the asset is
located in an outside environment,
and a setting of \code{"Indoor"} means the asset is located in an
 indoor environment. A setting of \code{"Default"} will result
  in either an indoor or an outdoor environment setting that depends
  on the specification of \code{asset_type}. See page 110-113,
  table 26 in CNAIM (2021) for default environments.}

\item{altitude_m}{Numeric. Specify the altitude location for
the asset measured in meters from sea level.\code{altitude_m}
is used to derive the altitude factor. See page 111,
table 23 in CNAIM (2021). A setting of \code{"Default"}
will set the altitude factor to 1 independent of \code{asset_type}.}

\item{distance_from_coast_km}{Numeric. Specify the distance from the
coast measured in kilometers. \code{distance_from_coast_km} is used
to derive the distance from coast factor See page 110,
table 22 in CNAIM (2021). A setting of \code{"Default"} will set the
 distance from coast factor to 1 independent of \code{asset_type}.}

\item{corrosion_category_index}{Integer.
Specify the corrosion index category, 1-5.}

\item{age}{Numeric. The current age in years.}

\item{partial_discharge}{String. Indicating the}

\item{temperature_reading}{String. Indicating the criticality.
Options for \code{temperature_reading}:
\code{temperature_reading = c("Normal", "Moderately High",
"Very High", "Default")}. See page 153, table 172 in CNAIM (2021).}

\item{observed_condition}{String. Indicating the observed condition of the
 transformer. Options for \code{observed_condition}:
\code{observed_condition = c("No deterioration", "Superficial/minor deterioration", "Slight deterioration",
 "Some Deterioration", "Substantial Deterioration", "Default")}. See page 130, table 81 in CNAIM (2021).}

\item{reliability_factor}{Numeric. \code{reliability_factor}
shall have a value between 0.6 and 1.5. A setting of \code{"Default"}
 sets the \code{reliability_factor} to 1.
See section 6.14 on page 73 in CNAIM (2021).}

\item{moisture}{Numeric. the amount of moisture given in (ppm) See page 162, table 203 in CNAIM (2021).}

\item{oil_acidity}{Oil Acidity
level of partial discharge. Options for \code{partial_discharge}:
\code{partial_discharge = c("Low", "Medium", "High (Not Confirmed)",
 "High (Confirmed)", "Default")}. See page 153, table 171 in CNAIM (2021).}

\item{bd_strength}{Numeric. the amount of breakdown strength given in (kV) See page 162, table 205 in CNAIM (2021).}
}
\value{
DataFrame Current probability of failure
per annum per kilometer along with current health score.
}
\description{
This function calculates the current
annual probability of failure for 6.6/11kV and 20kV transformers.
The function is a cubic curve that is based on
the first three terms of the Taylor series for an
exponential function. For more information about the
probability of failure function see section 6
on page 34 in CNAIM (2021).
}
\examples{
# Current probability of failure for a 6.6/11 kV transformer
pof_transformer_11_20kv(hv_transformer_type = "6.6/11kV Transformer (GM)",
utilisation_pct = "Default",
placement = "Default",
altitude_m = "Default",
distance_from_coast_km = "Default",
corrosion_category_index = "Default",
age = 10,
partial_discharge = "Default",
temperature_reading = "Default",
observed_condition = "Default",
reliability_factor = "Default",
moisture = "Default",
oil_acidity = "Default",
bd_strength = "Default")
}
