% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_T_Mu.R
\name{T_Mu}
\alias{T_Mu}
\title{T_Mu statistic}
\usage{
T_Mu(treatment, response, strata = NULL, degree)
}
\arguments{
\item{treatment}{a vector of treatment values.}

\item{response}{a vector of response values.}

\item{strata}{a variable defining the strata.}

\item{degree}{the degree assessment required.}
}
\value{
The function returns the test statistic for an unconditional CMH MS
equivalent test of required \code{degree}.
}
\description{
\code{T_Mu} returns the test statistic for an unconditional CMH MS equivalent
test of required \code{degree}. This function is used in the
\code{unconditional_CMH} function.
}
\examples{
attach(job_satisfaction)
T_Mu(treatment = income, response = as.numeric(satisfaction),
strata = gender, degree = 1)
}
\references{
Rayner, J.C.W and Livingston, G. C. (2022). An Introduction to Cochran-Mantel-Haenszel Testing and Nonparametric ANOVA. Wiley.
}
\seealso{
\code{\link[=unconditional_CMH]{unconditional_CMH()}}
}
