% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{print.visualize_correlations}
\alias{print.visualize_correlations}
\title{Print centrality correlation plot}
\usage{
\method{print}{visualize_correlations}(x, scale = TRUE,
  method = c("pearson", "kendall", "spearman"), file = NULL)
}
\arguments{
\item{x}{a list indicating calculated centrality measures which is the output of
"calculate_centralities" function}

\item{scale}{Whether the centrality values should be scaled or not(default=TRUE)}

\item{method}{character string describing the type of correlation coefficient (or covariance)
to be computed. The proper values are "pearson", "kendall", or "spearman". (default="pearson")}

\item{file}{A character string naming the .pdf file to print into. If NULL the result would
be printed to the exist directory.(default=NULL)}
}
\value{
The resulted plot of \code{ \link[CINNA]{visualize_correlations}}function will be saved in the given directory.#' @importFrom igraph alpha.centrality
}
\description{
This function prints a plot including all pairwise correlation between
centrality measures
}
\author{
Minoo Ashtiani, Mohieddin Jafari
}
