% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coupledHMM.R
\name{coupledHMM}
\alias{coupledHMM}
\title{Perform inference of coupled hidden markov models.}
\usage{
coupledHMM(X, nb.states = 3, S = NULL, omega.list = c(0.3, 0.7, 0.9),
  var.equal = TRUE, exact = FALSE, meth.init = "mclust", viterbi = TRUE,
  itmax = 500, threshold = 1e-07)
}
\arguments{
\item{X}{a matrix of observations. Columns correspond to series (individuals).}

\item{nb.states}{a integer specifying the numbers of states.}

\item{S}{a matrix of similarity between individuals.}

\item{omega.list}{a vector of omega values.}

\item{var.equal}{a logical variable indicating whether to treat the variances as being equal (var.equal = TRUE).}

\item{exact}{a logical variable indicating whether to use VEM (exact = FALSE) or EM (exact = TRUE) algorithm for the inference of the model.}

\item{meth.init}{a string specifying the initialization method ("mclust" or "kmeans") for the (V)-EM algorithm. The default method is "mclust".}

\item{viterbi}{a logical variable indicating whether to use Maximum A Posteriori method (FALSE) or Viterbi algorithm (TRUE, by default) for recovering the most likely path.}

\item{itmax}{an integer specifying the maximal number of iterations for the CHMM_(V)EM algorithm.}

\item{threshold}{a value for the threshold used for the stopping criteria for the CHMM_(V)EM algorithm.}
}
\value{
A list of 4 objets.
\describe{
\item{\code{omega}}{ an integer corresponding to the selected value among the omega.list.}
\item{\code{model}}{a list corresponding to the output of the \code{CHMM-EM} or \code{CHMM-VEM} function for the selected model.}
\item{\code{status}}{a matrix with status associated to each series in column and each position in row.}
\item{\code{RSS.omega}}{ a dataframe with omega values and the associated Residuals Sum of Squares.}
}
}
\description{
Perform inference of coupled hidden markov models.
}
\examples{
data(toyexample)
# Variational inference of a coupled hidden Markov Chains
resCHMM <- coupledHMM(X = toydata, nb.states = 3, S = cor(toystatus),
                      omega.list = c(0.3, 0.5, 0.7, 0.9))
# Breakpoints positions and status of segments
info <- clusterseg(resCHMM$status)
# head(info)
}
\references{
Wang, X., Lebarbier, E., Aubert, J. and Robin, S., Variational inference for coupled Hidden Markov Models applied to the joint detection of copy number variations.
}
\seealso{
\code{\link{CHMM_VEM}}, \code{\link{CHMM_EM}}
}
