% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{CGGPplotvariogram}
\alias{CGGPplotvariogram}
\title{Plot something similar to a semivariogram}
\usage{
CGGPplotvariogram(CGGP, facet = 1, outdims = NULL)
}
\arguments{
\item{CGGP}{CGGP object}

\item{facet}{How should the plots be faceted? If 1, in a row,
if 2, in a column, if 3, wrapped around.}

\item{outdims}{Which output dimensions should be shown.}
}
\value{
ggplot2 object
}
\description{
It's not actually a variogram or semivariogram.
It shows how the correlation function falls off as distance increases.
}
\examples{
SG <- CGGPcreate(d=3, batchsize=100)
f <- function(x){x[1]^1.2+x[3]^.4*sin(2*pi*x[2]^2*3) + .1*exp(3*x[3])}
y <- apply(SG$design, 1, f)
SG <- CGGPfit(SG, Y=y)
CGGPplotvariogram(SG)
}
\seealso{
Other CGGP plot functions: \code{\link{CGGPplotblocks}},
  \code{\link{CGGPplotcorr}}, \code{\link{CGGPplotheat}},
  \code{\link{CGGPplothist}},
  \code{\link{CGGPplotsamplesneglogpost}},
  \code{\link{CGGPplotslice}}, \code{\link{CGGPplottheta}},
  \code{\link{CGGPvalplot}}
}
\concept{CGGP plot functions}
