% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{CGGPplotsamplesneglogpost}
\alias{CGGPplotsamplesneglogpost}
\title{Plot negative log posterior likelihood of samples}
\usage{
CGGPplotsamplesneglogpost(CGGP)
}
\arguments{
\item{CGGP}{CGGP object}
}
\value{
ggplot2 object
}
\description{
Plot negative log posterior likelihood of samples
}
\examples{
gs <- CGGPcreate(d=3, batchsize=100)
f <- function(x){x[1]^1.2+x[3]^.4*sin(2*pi*x[2]^2*3) + .1*exp(3*x[3])}
y <- apply(gs$design, 1, f)
gs <- CGGPfit(gs, Y=y)
CGGPplotsamplesneglogpost(gs)
}
\seealso{
Other CGGP plot functions: \code{\link{CGGPplotblocks}},
  \code{\link{CGGPplotcorr}}, \code{\link{CGGPplotheat}},
  \code{\link{CGGPplothist}}, \code{\link{CGGPplotslice}},
  \code{\link{CGGPplottheta}},
  \code{\link{CGGPplotvariogram}},
  \code{\link{CGGPvalplot}}
}
\concept{CGGP plot functions}
