% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFparse.R
\name{CFparse}
\alias{CFparse}
\title{Parse series of timestamps in CF format to date-time elements}
\usage{
CFparse(cf, x)
}
\arguments{
\item{cf}{CFtime. An instance of \code{CFtime} indicating the CF calendar and
datum to use when parsing the date.}

\item{x}{character. Vector of character strings representing timestamps in
ISO8601 extended or UDUNITS broken format.}
}
\value{
A data frame with constituent elements of the parsed timestamps in
numeric format. The columns are year, month, day, hour, minute, second
(with an optional fraction), time zone (character string), and the
corresponding offset value from the datum. Invalid input data will appear
as \code{NA} - if this is the case, a warning message will be displayed - other
missing information on input will use default values.
}
\description{
This function will parse a vector of timestamps in ISO8601 or UDUNITS format
into a data frame with columns for the elements of the timestamp: year,
month, day, hour, minute, second, time zone. Those timestamps that could not
be parsed or which represent an invalid date in the indicated \code{CFtime}
instance will have \code{NA} values for the elements of the offending timestamp
(which will generate a warning).
}
\details{
The supported formats are the \emph{broken timestamp} format from the UDUNITS
library and ISO8601 \emph{extended}, both with minor changes, as suggested by the
CF Metadata Conventions. In general, the format is \verb{YYYY-MM-DD hh:mm:ss.sss hh:mm}. The year can be from 1 to 4 digits and is interpreted literally, so
\code{79-10-24} is the day Mount Vesuvius erupted and destroyed Pompeii, not
\code{1979-10-24}. The year and month are mandatory, all other fields are
optional. There are defaults for all missing values, following the UDUNITS
and CF Metadata Conventions. Leading zeros can be omitted in the UDUNITS
format, but not in the ISO8601 format. The optional fractional part can have
as many digits as the precision calls for and will be applied to the smallest
specified time unit. In the result of this function, if the fraction is
associated with the minute or the hour, it is converted into a regular
\code{hh:mm:ss.sss} format, i.e. any fraction in the result is always associated
with the second, rounded down to milli-second accuracy. The separator between
the date and the time can be a single whitespace character or a \code{T}.

The time zone is optional and should have at least the hour or \code{Z} if
present, the minute is optional. The time zone hour can have an optional
sign. In the UDUNITS format the separator between the time and the time zone
must be a single whitespace character, in ISO8601 there is no separation
between the time and the timezone. Time zone names are not supported (as
neither UDUNITS nor ISO8601 support them) and will cause parsing to fail when
supplied, with one exception: the designator "UTC" is silently dropped (i.e.
interpreted as "00:00").

Currently only the extended formats (with separators between the elements)
are supported. The vector of timestamps may have any combination of ISO8601
and UDUNITS formats.

Timestamps that are prior to the datum are not allowed. The corresponding row
in the result will have \code{NA} values.
}
\examples{
cf <- CFtime("days since 0001-01-01", "proleptic_gregorian")

# This will have `NA`s on output and generate a warning
timestamps <- c("2012-01-01T12:21:34Z", "12-1-23", "today",
                "2022-08-16T11:07:34.45-10", "2022-08-16 10.5+04")
CFparse(cf, timestamps)
}
