% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelKrigingPredict.R
\name{simulate.modelKriging}
\alias{simulate.modelKriging}
\title{Kriging Simulation}
\usage{
\method{simulate}{modelKriging}(
  object,
  nsim = 1,
  seed = NA,
  xsim,
  conditionalSimulation = TRUE,
  returnAll = FALSE,
  ...
)
}
\arguments{
\item{object}{fit of the Kriging model (settings and parameters), of class \code{modelKriging}.}

\item{nsim}{number of simulations}

\item{seed}{random number generator seed. Defaults to NA, in which case no seed is set}

\item{xsim}{list of samples in input space, to be simulated}

\item{conditionalSimulation}{logical, if set to TRUE (default), the simulation is conditioned with the training data of the Kriging model.
Else, the simulation is non-conditional.}

\item{returnAll}{if set to TRUE, a list with the simulated values (y) and the corresponding covariance matrix (covar)
of the simulated samples is returned.}

\item{...}{further arguments, not used}
}
\value{
Returned value depends on the setting of \code{object$simulationReturnAll}
}
\description{
(Conditional) Simulate at given locations, with a model fit resulting from \code{\link{modelKriging}}.
In contrast to prediction or estimation, the goal is to reproduce the covariance 
structure, rather than the data itself. Note, that the conditional simulation 
also reproduces the training data, but
has a two times larger error than the Kriging predictor.
}
\references{
N. A. Cressie. Statistics for Spatial Data. JOHN WILEY & SONS INC, 1993.

C. Lantuejoul. Geostatistical Simulation - Models and Algorithms. Springer-Verlag Berlin Heidelberg, 2002.
}
\seealso{
\code{\link{modelKriging}}, \code{\link{predict.modelKriging}}
}
