% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericDistances.R
\name{distanceNumericLevenshtein}
\alias{distanceNumericLevenshtein}
\title{Levenshtein Distance for Numeric Vectors}
\usage{
distanceNumericLevenshtein(x, y)
}
\arguments{
\item{x}{first vector (numeric)}

\item{y}{second vector (numeric)}
}
\value{
numeric distance value \deqn{d(x,y)}, scaled to values between 0 and 1
}
\description{
Levenshtein distance for two numeric vectors, e.g., bit vectors.
}
\examples{
#e.g., used for distance between bit strings
x <- c(0,1,0,1,0)
y <- c(1,1,0,0,1)
distanceNumericLevenshtein(x,y)
p <- replicate(10,sample(c(0,1),5,replace=TRUE),simplify=FALSE)
distanceMatrix(p,distanceNumericLevenshtein)

}
