% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelKriging.R
\name{modelKrigingInit}
\alias{modelKrigingInit}
\title{Kriging: Initial guess and bounds}
\usage{
modelKrigingInit(startTheta = NULL, lowerTheta, upperTheta, optimizeP,
  useLambda, lambdaLower, lambdaUpper, combineDistances, nd)
}
\arguments{
\item{startTheta}{user provided start guess (optional).}

\item{lowerTheta}{lower boundary for theta values (log scale).}

\item{upperTheta}{upper boundary for theta values (log scale).}

\item{optimizeP}{boolean, whether parameter p is optimized.}

\item{useLambda}{boolean, whether nugget effect (lambda) is used.}

\item{lambdaLower}{lower boundary for lambda (log scale).}

\item{lambdaUpper}{upper boundary for lambda (log scale).}

\item{combineDistances}{boolean, whether multiple distances are combined.}

\item{nd}{number of distance function.}
}
\value{
a list with elements \code{x0} (start guess), \code{lower} (lower bound), \code{upper} (upper bound).
}
\description{
Initialize parameter tuning for the Kriging model, setting the initial guess
as well as bound constraints.
}
\seealso{
\code{\link{modelKriging}}
}
\keyword{internal}

