% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_io.R
\name{select_patient}
\alias{select_patient}
\title{Select Next Patient to Review}
\usage{
select_patient(
  uri_fun,
  user,
  password,
  host,
  port,
  database,
  end_user,
  patient_id = NA
)
}
\arguments{
\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}

\item{end_user}{CEDARS end user name.}

\item{patient_id}{Used if a specific patient record is requested, instead of a search for next record to annotate.}
}
\value{
Selected patient_id.
}
\description{
Selects next available patient to review by CEDARS end user. If a patient record is already locked it will be used, otherwise next in line is choosen. If a specific patinet ID was requested, record will be locked and selected.
}
\keyword{internal}
