% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries.R
\name{mrrel_upload}
\alias{mrrel_upload}
\title{Upload UMLS Relationships}
\usage{
mrrel_upload(path, uri_fun, user, password, host, port, database)
}
\arguments{
\item{path}{Path to file MRREL.RRF.}

\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}
}
\value{
{
Progress report of UMLS processing and upload.
}
}
\description{
Prepares and uploads UMLS MRREL.RRF file. This file is not included in the CEDARS package and can be obtained on the NIH web site at https://www.nlm.nih.gov/research/umls/index.html. It is very large and not currently used by CEDARS.
}
\examples{
\dontrun{
mrrel_upload(path = 'dictionaries/MRREL.RRF', uri_fun = mongo_uri_standard, user = 'John',
password = 'db_password_1234', host = 'server1234', port = NA, database = 'TEST_PROJECT')
}
}
