% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries.R
\name{mrconso_upload}
\alias{mrconso_upload}
\title{Upload UMLS Dictionary}
\usage{
mrconso_upload(
  path,
  language = "ENG",
  subsets,
  max_grams = 7,
  uri_fun,
  user,
  password,
  host,
  port,
  database
)
}
\arguments{
\item{path}{Path to file MRCONSO.RRF.}

\item{language}{Language of biomedical lexicon, default is English (ENG).}

\item{subsets}{Character vector of lexicon subsets to retain. UMLS is quite large so most applications can use only a few lexicon subsets.}

\item{max_grams}{Maximum length of token in grams. Tokens above the thresold length will not be retained. Empirically, a value of 7 suffices for most applications.}

\item{uri_fun}{Uniform resource identifier (URI) string generating function for MongoDB credentials.}

\item{user}{MongoDB user name.}

\item{password}{MongoDB user password.}

\item{host}{MongoDB host server.}

\item{port}{MongoDB port.}

\item{database}{MongoDB database name.}
}
\value{
{
Progress report of dictionary processing and upload.
}
}
\description{
Prepares and uploads UMLS MRCONSO.RRF file. This file is not included in the CEDARS package and can be obtained on the NIH web site at https://www.nlm.nih.gov/research/umls/index.html.
}
\examples{
\dontrun{
mrconso_upload(path = 'dictionaries/MRCONSO.RRF', language = 'ENG', subsets = c('SNOMEDCT_US',
'MTHICD9', 'ICD9CM', 'ICD10', 'ICD10CM', 'DSM-5', 'MSH', 'RXNORM', 'NCI'), max_grams = 7,
user = 'John', password = 'db_password_1234', host = 'server1234', port = NA,
database = 'TEST_PROJECT')
}
}
