% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDFtestingSuite.R
\name{CDFtestTrack}
\alias{CDFtestTrack}
\title{Test a single CDF implementation with one set of parameters.}
\usage{
CDFtestTrack(funct, eps, cdfstep = 1, data, range, gran, reps,
  SmoothAll = FALSE, ABounds = FALSE, EmpiricBounds = FALSE,
  ExtraTests_CDF = list(), ExtraTests_PDF = list(), ...)
}
\arguments{
\item{funct}{The differentially-private CDF-generating function to be tested}

\item{eps}{Epsilon value for Differential privacy control}

\item{cdfstep}{The step sized used in outputting the approximate CDF; the 
values output are [min, min + cdfstep], [min, min + 2 * cdfstep], etc. 
Setting cdfstep equal to 0 (default) will set cdfstep = granularity}

\item{data}{A vector of the data (single variable to compute CDFs from)}

\item{range}{A vector length 2 containing user-specified min and max to
truncate the universe to.}

\item{gran}{The smallest unit of measurement in the data (one [year] for a
list of ages). The Domain (ie gran and range) should be identical to those 
used to create the CDF!}

\item{reps}{The number of times the combination of CDFfunction, dataset, and 
epsilon will be tested}

\item{SmoothAll}{Applies L2 monotnocity post-processing to every DP-CDF}

\item{ABounds}{This is a flag and should be set to "true" if the functions 
being tested are expected to output 
analytical variance bounds. The proper output form is 
output = list(DPCDFvector, LowerBoundVector, UpperBoundVector)}

\item{EmpiricBounds}{When TRUE, outputted graphs
depict the minimum and maximum values taken by each bin across reps}

\item{ExtraTests_CDF}{If a user wishes to add extra diagnostics, the proper 
syntax would be:
ExtraTests_CDF = list( functionName1 = function1, functionName2 = function2)}

\item{ExtraTests_PDF}{See above}

\item{...}{Optionally add additional parameters. This is primarily used to allow automated
execution of varied diagnostic functions.}
}
\value{
A list in the form of:

...\code{$meanscores} Contains mean diagnostic
 results for each diagnostic across reps iterations;
 
...\code{$medianscores} Contains median diagnostic 
 results for each diagnostic across reps iterations;
 
...\code{$yourCDFoutput} Containing a single dpCDF iteration;

...\code{$yourPDFoutput}  Containing a single dpPDF iteration;

...\code{$realCDFoutput} Containing the real (non-DP) CDF output;

...\code{$realPDFoutput} Containing the real (non-DP) PDF output;

...\code{$databins} Containing the domain used to construct the CDFs;

...\code{$TestPack_CDF} Containing the definitions of diagnostic functions used on dpCDFs;

...\code{$TestPack_PDF} Containing the definitions of diagnostic functions used on dpPDFs;

...\code{$allscores} Containing all raw diagnostic output.
}
\description{
Generates mean/median empirical error measurements, complete
   results, single iterations of DP CDFs at each combination of parameters,
   and diagnostic functions used.
}
\examples{
CDFtestTrack(badCDF, eps = .01, cdfstep = 1, data = rexp(10000,.4),
range= c(1,10), gran = .1, reps = 20)
}

