% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{clusters}
\alias{clusters}
\title{Obtain clustering from a clusterpath}
\usage{
clusters(obj, n_clusters)
}
\arguments{
\item{obj}{A \code{cvxclust} object.}

\item{n_clusters}{An integer that specifies the number of clusters that
should be returned.}
}
\value{
A vector with the cluster labels for each object in the data.
}
\description{
Get a particular clustering of the data. If there is a
clustering for \code{n_clusters}, it is returned, otherwise the function will
stop with a message. To know whether a query is going to be successful
beforehand, check the \code{num_clusters} attribute of the \code{cvxclust}
object, this lists all possible options for the number of clusters.
}
\examples{
# Load data
data(two_half_moons)
data = as.matrix(two_half_moons)
X = data[, -3]
y = data[, 3]

# Get sparse distances in dictionary of keys format with k = 5 and phi = 8
W = sparse_weights(X, 5, 8.0)

# Set a sequence for lambda
lambdas = seq(0, 2400, 1)

# Compute results CMM
res = convex_clusterpath(X, W, lambdas)

# Get labels for three clusters
labels = clusters(res, 3)

}
