% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_C_intersection.R
\name{get_C_intersection}
\alias{get_C_intersection}
\title{Get Cartesian coordinates of lines intersection in Euclidean space}
\usage{
get_C_intersection(Line1, Line2, Plot = TRUE)
}
\arguments{
\item{Line1}{Vector of 4 coordinates, given in decimal degrees as: 

\code{c(Longitude_start,Latitude_start,Longitude_end,Latitude_end)}.}

\item{Line2}{Same as \code{Line1}.}

\item{Plot}{logical, if set to TRUE, plots a schematic of calculations.}
}
\description{
Given two lines defined by the Latitudes/Longitudes of their extremities, finds the location of their 
intersection, in Euclidean space, using 
this approach: \url{https://en.wikipedia.org/wiki/Line-line_intersection}.
}
\examples{
\donttest{


#Example 1 (Intersection beyond the range of segments)
get_C_intersection(Line1=c(-30,-55,-29,-50),Line2=c(-50,-60,-40,-60))

#Example 2 (Intersection on one of the segments)
get_C_intersection(Line1=c(-30,-65,-29,-50),Line2=c(-50,-60,-40,-60))

#Example 3 (Crossed segments)
get_C_intersection(Line1=c(-30,-65,-29,-50),Line2=c(-50,-60,-25,-60))

#Example 4 (Antimeridian crossed)
get_C_intersection(Line1=c(-179,-60,-150,-50),Line2=c(-120,-60,-130,-62))

#Example 5 (Parallel lines - uncomment to test as it will return an error)
#get_C_intersection(Line1=c(0,-60,10,-60),Line2=c(-10,-60,10,-60))


}

}
