% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countCropCycles.R
\name{countCropCycles}
\alias{countCropCycles}
\title{countCropCycles}
\usage{
countCropCycles(x, min.length = c(1, 1))
}
\arguments{
\item{x}{Target numeric \emph{vector}.}

\item{min.length}{Two element numeric \emph{vector}.}
}
\value{
A \emph{numeric} element with the number of crop cycles in \emph{x}.
}
\description{
Matches two vectors with different lengths based on their maximum value.
}
\details{
{The function counts the number of value segments in \emph{x} that are above its mean 
effectively counting the number of crop cycles. Before reporting the final value, \emph{min.length} 
is used to filter outliers. The first element filters segments that lie below the mean (i.e. recently 
cultivated/harvested). If the segment length is greater than the 1st element in \emph{min.length} the 
segment is relabeled as "1 (i.e. "crop growth/maturity". This process is repeated for segments above 
the mean (i.e. crop growth/maturity). If the length of a segment is greater than the second element in 
\emph{min.length} it is labeled as "recently cultivated/harvested".}
}
\examples{
{

x <- c(293, 770, 1166, 1166, 1562, 2357, 3234, 
5806, 5806, 5678, 5678, 5546, 5536, 5536, 5536, 
5325, 5200, 4726, 3550, 2868, 2365, 2365, 2365)

n <- countCropCycles(x)

}
}
