% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carrot_functions.R
\name{get_predictions}
\alias{get_predictions}
\title{Predictions for multinomial regression}
\usage{
get_predictions(p,k,cutoff,mode)
}
\arguments{
\item{p}{probabilities of the outcomes for the test set given either by an array (logistic regression) or by a matrix (multinomial regression)}

\item{k}{size of the test set}

\item{cutoff}{cut-off value of the probability}

\item{mode}{\code{'binary'} (logistic regression), \code{'multin'} (multinomial regression)}
}
\value{
Outputs the array of the predictions of the size of \code{p}.
}
\description{
Function which makes a prediction for multinomial/logistic regression based on the given cut-off value and probabilities.
}
\examples{
#binary mode

get_predictions(runif(20,0.4,0.6),20,0.5,'binary')

#creating a data-set for multinomial mode

p1<-runif(20,0.4,0.6)
p2<-runif(20,0.1,0.2)
p3<-1-p1-p2

#running the function

get_predictions(matrix(c(p1,p2,p3),ncol=3),20,0.5,'multin')
}
\seealso{
Uses \code{\link[stats]{rbinom}}, \code{\link[stats]{rmultinom}}
}
