% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PooledLSD.R
\name{PooledLSD}
\alias{PooledLSD}
\title{Pooled Latin Square Design Analysis}
\usage{
PooledLSD(
  data,
  Response,
  Location,
  Treatment,
  Row,
  Column,
  alpha,
  Mult_Comp_Test
)
}
\arguments{
\item{data}{A data frame containing the experimental data.}

\item{Response}{A numeric variable representing the dependent variable (response).}

\item{Location}{A factor indicating different locations or years.}

\item{Treatment}{A factor indicating the different treatments applied.}

\item{Row}{A factor indicating rows.}

\item{Column}{A factor indicating columns.}

\item{alpha}{A numeric value specifying the significance level for Bartlett’s test.}

\item{Mult_Comp_Test}{An integer specifying the type of multiple comparison test:
\itemize{
  \item 1 = Tukey's honestly significant difference (Tukey's HSD) test
  \item 2 = Duncan's multiple range test (DMRT)
  \item 3 = least significant difference (LSD) test
}}
}
\value{
A list containing the following components:
  \itemize{
    \item \strong{Individual_ANOVA}: Summary of ANOVA results for each location or year.
    \item \strong{Location_wise}: Multiple comparisons of treatments within each location or year.
    \item \strong{Bartlett_Test}: Results of Bartlett's test for homogeneity of variances.
    \item \strong{Pooled_ANOVA}: Combined (pooled) ANOVA table across all locations or years.
    \item \strong{Treatments_Comparison}: Summary of pooled treatment comparisons using the selected multiple comparison test.
  }
}
\description{
This function performs pooled analysis of variance (ANOVA) using the Latin square design for multiple locations or years. For more details see Montgomery (2017), Dean et al. (2017)<doi:10.1007/978-3-319-52250-0> and Ruíz et al. (2024)<doi:10.1007/978-3-031-65575-3>.
}
\examples{
# Creating a sample dataset for Pooled Latin Square Design (LSD)
df <- data.frame(
  Location = factor(c(rep("Agra", 16), rep("Bihar", 16))),  # Locations
  Treatment = factor(c(4, 2, 3, 1, 3, 1, 4, 2, 1, 4, 2, 3, 2, 3, 1, 4,
  4, 2, 3, 1, 3, 1, 4, 2, 1, 4, 2, 3, 2, 3, 1, 4)),  # Treatments
  Row = factor(rep(1:4, each = 4, times = 2)),  # Row factor
  Column = factor(rep(1:4, times = 8)),  # Column factor
  Yield = c(29.1, 18.9, 29.4, 5.7, 16.4, 10.2, 21.2, 19.1, 5.4, 38.8, 24, 37, 
            24.9, 41.7, 9.5, 28.9, 13, 27, 7, 24, 10, 13, 41, 39, 42, 26, 19, 20, 
            20, 35, 8, 38)  # Yield values
)

# Running PooledLSD function on the dataset
out <- PooledLSD(df, "Yield", "Location", "Treatment", "Row", "Column", 0.05, 1)

# Print results
print(out)
}
\references{
Dean A, Voss D, Draguljic D (2017)<doi:10.1007/978-3-319-52250-0>.

Montgomery DC (2017). \emph{Design and Analysis of Experiments}. John wiley & sons.

Ruíz JS, López OAM, Crossa J (2024)<doi:10.1007/978-3-031-65575-3>.
}
