% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar_annotation.R
\name{annotation_mat}
\alias{annotation_mat}
\title{Annotate Cells Using Distance Matrix and Marker Frequencies}
\usage{
annotation_mat(
  distce,
  marker.freq,
  gene.use = NULL,
  cal.confidence = TRUE,
  cal.proportions = TRUE,
  parallel = TRUE,
  ncores = 10,
  n_fake = 1001,
  seed = 1,
  threshold = 0.95,
  unassign = "unassigned"
)
}
\arguments{
\item{distce}{A matrix of distances between spots and genes. Rows represent genes, and columns represent cells. Generally, it is a list of the output of function \code{ProFAST::pdistance} with CAESAR co-embedding as input.}

\item{marker.freq}{A matrix where rows represent cell types, and columns represent marker genes. The values in the matrix represent the frequency or weight of each marker gene for each cell type. Generally, it is a list of the output of function \code{markerList2mat}.}

\item{gene.use}{A character vector specifying which genes to use for the annotation. If `NULL`, all genes in `distce` will be used. Default is `NULL`.}

\item{cal.confidence}{Logical, indicating whether to calculate the confidence of the predictions. Default is `TRUE`.}

\item{cal.proportions}{Logical, indicating whether to calculate the mixing proportions of cell types for each spot. Default is `TRUE`.}

\item{parallel}{Logical, indicating whether to run the confidence calculation in parallel. Default is `TRUE`.}

\item{ncores}{The number of cores to use for parallel computation. Default is 10.}

\item{n_fake}{The number of fake (randomized) distance matrices to simulate for confidence calculation. Default is 1001.}

\item{seed}{The random seed for reproducibility. Default is 1.}

\item{threshold}{A numeric value specifying the confidence threshold below which a cell is labeled as `unassigned`. Default is 0.95.}

\item{unassign}{A character string representing the label to assign to cells below the confidence threshold. Default is `"unassigned"`.}
}
\value{
A list with the following components:
\item{ave.dist}{A matrix of average distances between each cell and each cell type.}
\item{confidence}{A numeric vector of confidence values for each cell (if `cal.confidence = TRUE`).}
\item{pred}{A character vector of predicted cell types for each cell.}
\item{pred_unassign}{A character vector of predicted cell types with cells below the confidence threshold labeled as `unassigned` (if `cal.confidence = TRUE`).}
\item{cell_mixing_proportions}{A matrix of mixing proportions for each spot across the different cell types (if `cal.proportions = TRUE`).}
}
\description{
This function annotates cells based on a cell-gene distance matrix and marker gene frequencies. It computes the average distances, optionally calculates confidence levels for the predictions, and computes cell mixing proportions.
}
\examples{
data(toydata)

seu <- toydata$seu
markers <- toydata$markers

seu <- ProFAST::pdistance(seu, reduction = "caesar")
distce <- Seurat::GetAssayData(object = seu, slot = "data", assay = "distce")

marker.freq <- markerList2mat(list(markers))

anno_res <- annotation_mat(distce, marker.freq, cal.confidence = FALSE, cal.proportions = FALSE)
str(anno_res)
}
\seealso{
\code{\link{marker.select}} for select markers.
\code{\link{find.sig.genes}} for signature gene list.
\code{\link{markerList2mat}} for marker frequency matrix.
\code{\link[ProFAST]{pdistance}} for obtain cell-gene distance matrix using co-embedding.
}
