package org.neptuneinc.cadstat.plots;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.SpinnerNumberModel;

import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

/**
 *
 * @author  Pasha Minallah
 */
public class FactorAnalysis extends DataPlotDialog
{
  /**
   * Creates new form LinearRegression
   */
  public FactorAnalysis()
  {
    super();
  }

  /** Perform custom initialization. */
  @Override
  protected void initCustom()
  {
    this.initComponents();

    this.getPlotPane().add(plotPane, BorderLayout.CENTER);

    this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        datasetComboBoxActionPerformed(e);
      }
    });

    this.refreshVariableList();
    this.refreshNumFactorsSpinner();
    this.refreshValidity();
  }

  private void datasetComboBoxActionPerformed(ActionEvent e)
  {
    this.refreshVariableList();
    this.refreshNumFactorsSpinner();
    this.refreshValidity();
  }

  public void refreshVariableListValidity()
  {
    boolean datasetValid = this.getDatasetPane().getDatasetComboBox().getItemCount() > 0;

    varList.setEnabled(datasetValid && varList.getModel().getSize() > 0);
  }

  public void refreshVariableList()
  {
    if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0)
    {
      Vector numerics = null;

      try
      {
        numerics = RUtils.colnamesNumericVector(this.getDatasetPane().getSelectedDataset());

        if (numerics != null)
        {
          varList.setListData(numerics);
        }
        else
        {
          varList.removeAll();
        }
      }
      catch (REngineException ex)
      {
        Logger.getLogger(FactorAnalysis.class.getName()).log(Level.SEVERE, null, ex);
      }
      catch (REXPMismatchException ex)
      {
        Logger.getLogger(FactorAnalysis.class.getName()).log(Level.SEVERE, null, ex);
      }
    }
    else
    {
      varList.removeAll();
    }

    this.refreshValidity();
  }

  public void refreshNumFactorsSpinner()
  {
    int numFactors = (Integer) numFactorsSpinner.getValue();

    numFactorsSpinner.setModel(new SpinnerNumberModel(numFactors,
      0, new Double(Math.floor(varList.getModel().getSize() / 2.0)).intValue(), 1));

    numFactorsSpinner.setValue(numFactors);
  }

  public void refreshDataLists()
  {
    int[] varIndices = varList.getSelectedIndices();

    this.getDatasetPane().refreshDatasetComboBox();
    this.refreshNumFactorsSpinner();

    varList.setSelectedIndices(varIndices);

    this.refreshFactorSelectionPanes();
    this.refreshValidity();
  }

  public void refreshAnalysisTabValidity()
  {
    if (((Integer) numFactorsSpinner.getValue()) == 0)
    {
      rightPane.setEnabledAt(0, true);
      rightPane.setEnabledAt(1, false);

      rightPane.setSelectedIndex(0);
    }
    else
    {
      rightPane.setEnabledAt(0, false);
      rightPane.setEnabledAt(1, true);

      rightPane.setSelectedIndex(1);
    }
  }

  public void refreshSubmitButtonValidity()
  {
    boolean status;

    int numVars = varList.isSelectionEmpty() ? 0 : varList.getSelectedIndices().length;
    int numFactors = (Integer) numFactorsSpinner.getValue();

    // Principal Components Analysis
    if (numFactors == 0)
    {
      status = (numVars > 0);
    }

    // Factor Analysis
    else
    {
      double degreesFreedom = 0.5 * ((numVars - numFactors) ^ 2 - numVars - numFactors);

      status = (numVars >= 3) && (degreesFreedom >= 0);
    }

    this.getSubmitButton().setEnabled(status);
  }

  public void refreshValidity()
  {
    this.refreshAnalysisTabValidity();
    this.refreshVariableListValidity();
    this.refreshSubmitButtonValidity();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    plotPane = new javax.swing.JPanel();
    leftPane = new javax.swing.JPanel();
    numFactorsPane = new javax.swing.JPanel();
    numFactorsLabel = new javax.swing.JLabel();
    numFactorsSpinner = new javax.swing.JSpinner();
    varPane = new javax.swing.JPanel();
    varScrollPane = new javax.swing.JScrollPane();
    varList = new javax.swing.JList();
    rightPane = new javax.swing.JTabbedPane();
    pcaPane = new javax.swing.JPanel();
    pcaOutputPane = new javax.swing.JPanel();
    screePlotCheckBox = new javax.swing.JCheckBox();
    loadingScorePlotCheckBox = new javax.swing.JCheckBox();
    rotateVarsCheckBox = new javax.swing.JCheckBox();
    pcaOptionsPane = new javax.swing.JPanel();
    centerZeroCheckBox = new javax.swing.JCheckBox();
    scaleUnitVarCheckBox = new javax.swing.JCheckBox();
    faPane = new javax.swing.JPanel();
    faRotationPane = new javax.swing.JPanel();
    varimaxRadioButton = new javax.swing.JRadioButton();
    promaxRadioButton = new javax.swing.JRadioButton();
    faScoresPane = new javax.swing.JPanel();
    scoresNoneRadioButton = new javax.swing.JRadioButton();
    scoresThompsonRadioButton = new javax.swing.JRadioButton();
    scoresBartlettRadioButton = new javax.swing.JRadioButton();
    jLabel1 = new javax.swing.JLabel();
    rotationButtonGroup = new javax.swing.ButtonGroup();
    scoresButtonGroup = new javax.swing.ButtonGroup();

    plotPane.setLayout(new java.awt.GridLayout(1, 2));

    leftPane.setPreferredSize(new java.awt.Dimension(320, 480));

    numFactorsPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Analysis Options"));

    numFactorsLabel.setText("No. of Factors:");

    numFactorsSpinner.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(0), Integer.valueOf(0), null, Integer.valueOf(1)));
    numFactorsSpinner.setRequestFocusEnabled(false);
    numFactorsSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
      public void stateChanged(javax.swing.event.ChangeEvent evt) {
        numFactorsSpinnerStateChanged(evt);
      }
    });

    javax.swing.GroupLayout numFactorsPaneLayout = new javax.swing.GroupLayout(numFactorsPane);
    numFactorsPane.setLayout(numFactorsPaneLayout);
    numFactorsPaneLayout.setHorizontalGroup(
      numFactorsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(numFactorsPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(numFactorsLabel)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(numFactorsSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 60, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(95, Short.MAX_VALUE))
    );
    numFactorsPaneLayout.setVerticalGroup(
      numFactorsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(numFactorsPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(numFactorsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(numFactorsLabel)
          .addComponent(numFactorsSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    varPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Variables"));

    varList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
      public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
        varListValueChanged(evt);
      }
    });
    varScrollPane.setViewportView(varList);

    javax.swing.GroupLayout varPaneLayout = new javax.swing.GroupLayout(varPane);
    varPane.setLayout(varPaneLayout);
    varPaneLayout.setHorizontalGroup(
      varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(varPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(varScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE)
        .addContainerGap())
    );
    varPaneLayout.setVerticalGroup(
      varPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(varPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(varScrollPane, javax.swing.GroupLayout.DEFAULT_SIZE, 412, Short.MAX_VALUE)
        .addContainerGap())
    );

    javax.swing.GroupLayout leftPaneLayout = new javax.swing.GroupLayout(leftPane);
    leftPane.setLayout(leftPaneLayout);
    leftPaneLayout.setHorizontalGroup(
      leftPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(varPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
      .addComponent(numFactorsPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
    );
    leftPaneLayout.setVerticalGroup(
      leftPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(leftPaneLayout.createSequentialGroup()
        .addComponent(numFactorsPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(varPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    plotPane.add(leftPane);

    rightPane.setPreferredSize(new java.awt.Dimension(320, 480));

    pcaOutputPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Output"));

    screePlotCheckBox.setText("Scree Plot");

    loadingScorePlotCheckBox.setText("Loading / Score Plot");

    rotateVarsCheckBox.setText("Rotated Variables");

    javax.swing.GroupLayout pcaOutputPaneLayout = new javax.swing.GroupLayout(pcaOutputPane);
    pcaOutputPane.setLayout(pcaOutputPaneLayout);
    pcaOutputPaneLayout.setHorizontalGroup(
      pcaOutputPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(pcaOutputPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(pcaOutputPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(screePlotCheckBox)
          .addComponent(loadingScorePlotCheckBox)
          .addComponent(rotateVarsCheckBox))
        .addContainerGap(59, Short.MAX_VALUE))
    );
    pcaOutputPaneLayout.setVerticalGroup(
      pcaOutputPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(pcaOutputPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(screePlotCheckBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(loadingScorePlotCheckBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(rotateVarsCheckBox)
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    pcaOptionsPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Options"));

    centerZeroCheckBox.setSelected(true);
    centerZeroCheckBox.setText("Center to 0");

    scaleUnitVarCheckBox.setSelected(true);
    scaleUnitVarCheckBox.setText("Scale to Unit Var");

    javax.swing.GroupLayout pcaOptionsPaneLayout = new javax.swing.GroupLayout(pcaOptionsPane);
    pcaOptionsPane.setLayout(pcaOptionsPaneLayout);
    pcaOptionsPaneLayout.setHorizontalGroup(
      pcaOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(pcaOptionsPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(pcaOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(centerZeroCheckBox)
          .addComponent(scaleUnitVarCheckBox))
        .addContainerGap(87, Short.MAX_VALUE))
    );
    pcaOptionsPaneLayout.setVerticalGroup(
      pcaOptionsPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(pcaOptionsPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(centerZeroCheckBox)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(scaleUnitVarCheckBox)
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    javax.swing.GroupLayout pcaPaneLayout = new javax.swing.GroupLayout(pcaPane);
    pcaPane.setLayout(pcaPaneLayout);
    pcaPaneLayout.setHorizontalGroup(
      pcaPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pcaPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(pcaPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(pcaOptionsPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addComponent(pcaOutputPane, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addContainerGap())
    );
    pcaPaneLayout.setVerticalGroup(
      pcaPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(pcaPaneLayout.createSequentialGroup()
        .addComponent(pcaOutputPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(pcaOptionsPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(248, Short.MAX_VALUE))
    );

    rightPane.addTab("Principal Components", pcaPane);

    faRotationPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Rotation"));

    rotationButtonGroup.add(varimaxRadioButton);
    varimaxRadioButton.setSelected(true);
    varimaxRadioButton.setText("Varimax");

    rotationButtonGroup.add(promaxRadioButton);
    promaxRadioButton.setText("Promax");

    javax.swing.GroupLayout faRotationPaneLayout = new javax.swing.GroupLayout(faRotationPane);
    faRotationPane.setLayout(faRotationPaneLayout);
    faRotationPaneLayout.setHorizontalGroup(
      faRotationPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(faRotationPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(faRotationPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(varimaxRadioButton)
          .addComponent(promaxRadioButton))
        .addContainerGap(163, Short.MAX_VALUE))
    );
    faRotationPaneLayout.setVerticalGroup(
      faRotationPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(faRotationPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(varimaxRadioButton)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(promaxRadioButton)
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    faScoresPane.setBorder(javax.swing.BorderFactory.createTitledBorder("Scores"));

    scoresButtonGroup.add(scoresNoneRadioButton);
    scoresNoneRadioButton.setSelected(true);
    scoresNoneRadioButton.setText("None");

    scoresButtonGroup.add(scoresThompsonRadioButton);
    scoresThompsonRadioButton.setText("Thompson");

    scoresButtonGroup.add(scoresBartlettRadioButton);
    scoresBartlettRadioButton.setText("Bartlett");

    javax.swing.GroupLayout faScoresPaneLayout = new javax.swing.GroupLayout(faScoresPane);
    faScoresPane.setLayout(faScoresPaneLayout);
    faScoresPaneLayout.setHorizontalGroup(
      faScoresPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(faScoresPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(faScoresPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addComponent(scoresNoneRadioButton)
          .addComponent(scoresThompsonRadioButton)
          .addComponent(scoresBartlettRadioButton))
        .addContainerGap(144, Short.MAX_VALUE))
    );
    faScoresPaneLayout.setVerticalGroup(
      faScoresPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(faScoresPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(scoresNoneRadioButton)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(scoresThompsonRadioButton)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(scoresBartlettRadioButton)
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    jLabel1.setText("<html>   <ul>     <li>At least 3 variables must be selected.</li>     <li>The degrees of freedom must be at least 0.  i.e., the number of factors specified should not be too large for the number of variables.</li>   </ul> </html>");
    jLabel1.setVerticalAlignment(javax.swing.SwingConstants.TOP);

    javax.swing.GroupLayout faPaneLayout = new javax.swing.GroupLayout(faPane);
    faPane.setLayout(faPaneLayout);
    faPaneLayout.setHorizontalGroup(
      faPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, faPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addGroup(faPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 284, Short.MAX_VALUE)
          .addComponent(faScoresPane, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addComponent(faRotationPane, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        .addContainerGap())
    );
    faPaneLayout.setVerticalGroup(
      faPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(faPaneLayout.createSequentialGroup()
        .addComponent(faRotationPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(faScoresPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(46, Short.MAX_VALUE))
    );

    rightPane.addTab("Factor", faPane);

    plotPane.add(rightPane);

    setTitle("Factor Analysis");

    java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
    setBounds((screenSize.width-646)/2, (screenSize.height-711)/2, 646, 711);
  }// </editor-fold>//GEN-END:initComponents

private void varListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_varListValueChanged
  this.refreshSubmitButtonValidity();
}//GEN-LAST:event_varListValueChanged

private void numFactorsSpinnerStateChanged(javax.swing.event.ChangeEvent evt)//GEN-FIRST:event_numFactorsSpinnerStateChanged
{//GEN-HEADEREND:event_numFactorsSpinnerStateChanged
  this.refreshAnalysisTabValidity();
}//GEN-LAST:event_numFactorsSpinnerStateChanged

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JCheckBox centerZeroCheckBox;
  private javax.swing.JPanel faPane;
  private javax.swing.JPanel faRotationPane;
  private javax.swing.JPanel faScoresPane;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JPanel leftPane;
  private javax.swing.JCheckBox loadingScorePlotCheckBox;
  private javax.swing.JLabel numFactorsLabel;
  private javax.swing.JPanel numFactorsPane;
  private javax.swing.JSpinner numFactorsSpinner;
  private javax.swing.JPanel pcaOptionsPane;
  private javax.swing.JPanel pcaOutputPane;
  private javax.swing.JPanel pcaPane;
  private javax.swing.JPanel plotPane;
  private javax.swing.JRadioButton promaxRadioButton;
  private javax.swing.JTabbedPane rightPane;
  private javax.swing.JCheckBox rotateVarsCheckBox;
  private javax.swing.ButtonGroup rotationButtonGroup;
  private javax.swing.JCheckBox scaleUnitVarCheckBox;
  private javax.swing.JRadioButton scoresBartlettRadioButton;
  private javax.swing.ButtonGroup scoresButtonGroup;
  private javax.swing.JRadioButton scoresNoneRadioButton;
  private javax.swing.JRadioButton scoresThompsonRadioButton;
  private javax.swing.JCheckBox screePlotCheckBox;
  private javax.swing.JList varList;
  private javax.swing.JPanel varPane;
  private javax.swing.JScrollPane varScrollPane;
  private javax.swing.JRadioButton varimaxRadioButton;
  // End of variables declaration//GEN-END:variables

  @Override
  protected void submitButtonAction()
  {
    String rotation = "NULL", scores = "NULL";

    if (varimaxRadioButton.isSelected())
    {
      rotation = "'varimax'";
    }
    else if (promaxRadioButton.isSelected())
    {
      rotation = "'promax'";
    }

    if (scoresNoneRadioButton.isSelected())
    {
      scores = "'none'";
    }
    else if (scoresThompsonRadioButton.isSelected())
    {
      scores = "'regression'";
    }
    else if (scoresBartlettRadioButton.isSelected())
    {
      scores = "'Bartlett'";
    }

    String cmd = "pca.fa.JGR("
      + "my.data=" + (this.getDatasetPane().getDatasetComboBox() != null && this.getDatasetPane().getDatasetComboBox().getSelectedIndex() != -1 ? this.getDatasetPane().getSelectedDataset() : "NULL")
      + ", numFactors=" + numFactorsSpinner.getValue()
      + ", variables=" + (varList.isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(varList.getSelectedValues(), ",", "'") + ")")
      + ", subset1.name=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'")
      + ", subset1.val=" + (this.getFactorSelectionPane1().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")")
      + ", subset2.name=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'")
      + ", subset2.val=" + (this.getFactorSelectionPane2().getFactorValueList().isSelectionEmpty() ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")")
      + ", iScreePlot=" + GUIUtils.getBooleanValueR(screePlotCheckBox)
      + ", iLoadingPlot=" + GUIUtils.getBooleanValueR(loadingScorePlotCheckBox)
      + ", retx=" + GUIUtils.getBooleanValueR(rotateVarsCheckBox)
      + ", center=" + GUIUtils.getBooleanValueR(centerZeroCheckBox)
      + ", scale=" + GUIUtils.getBooleanValueR(scaleUnitVarCheckBox)
      + ", rotation=" + rotation
      + ", scores=" + scores
      + ")";

    JGR.MAINRCONSOLE.execute(cmd, true);
  }

  @Override
  protected void helpButtonAction()
  {
    String cmd = "CADStat.help('pca.fa.JGR')";
    JGR.MAINRCONSOLE.execute(cmd, true);
  }

  @Override
  public void windowActivated(WindowEvent e)
  {
    refreshDataLists();
  }
}
