/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.ui.DatasetPane;
import org.neptuneinc.cadstat.ui.FactorSubsetPane;

public class DataPlotDialog
extends JDialog {
    private JPanel buttonPane;
    private JButton cancelButton;
    private JTabbedPane cardPane;
    private JPanel datasetCenteringPane;
    private DatasetPane datasetPane;
    private JPanel datasetParentPane;
    private JSeparator datasetSeparator;
    private FactorSubsetPane factorSelectionPane1;
    private FactorSubsetPane factorSelectionPane2;
    private JSeparator factorSeparator;
    private JButton helpButton;
    private JPanel plotPane;
    private JButton submitButton;
    private JPanel subsetPane;

    public DataPlotDialog() {
        this.initComponents();
        this.initGeneral();
        this.initCustom();
    }

    protected void initGeneral() {
        this.getDatasetPane().getDatasetLabel().setText("Active Dataset:");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataPlotDialog.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.getFactorSelectionPane1().getFactorLabel().setText("Factor 1:");
        this.getFactorSelectionPane2().getFactorLabel().setText("Factor 2:");
        this.getFactorSelectionPane1().setDataset(this.getDatasetPane().getSelectedDataset());
        this.getFactorSelectionPane2().setDataset(this.getDatasetPane().getSelectedDataset());
        this.updateValidity();
        this.getRootPane().setDefaultButton(this.getSubmitButton());
        this.setDefaultCloseOperation(2);
    }

    private void datasetComboBoxActionPerformed(ActionEvent evt) {
        this.getFactorSelectionPane1().setDataset(this.getDatasetPane().getSelectedDataset());
        this.getFactorSelectionPane2().setDataset(this.getDatasetPane().getSelectedDataset());
        this.updateValidity();
    }

    protected void initCustom() {
    }

    private void updateValidity() {
        this.getCardPane().setEnabledAt(1, this.getFactorSelectionPane1().getFactorComboBox().getItemCount() > 0);
    }

    private void initComponents() {
        this.cardPane = new JTabbedPane();
        this.plotPane = new JPanel();
        this.datasetParentPane = new JPanel();
        this.datasetCenteringPane = new JPanel();
        this.datasetPane = new DatasetPane();
        this.datasetSeparator = new JSeparator();
        this.subsetPane = new JPanel();
        this.factorSelectionPane1 = new FactorSubsetPane();
        this.factorSeparator = new JSeparator();
        this.factorSelectionPane2 = new FactorSubsetPane();
        this.buttonPane = new JPanel();
        this.cancelButton = new JButton();
        this.submitButton = new JButton();
        this.helpButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Scatterplot");
        this.plotPane.setLayout(new BorderLayout());
        this.datasetCenteringPane.add(this.datasetPane);
        GroupLayout datasetParentPaneLayout = new GroupLayout((Container)this.datasetParentPane);
        this.datasetParentPane.setLayout((LayoutManager)datasetParentPaneLayout);
        datasetParentPaneLayout.setHorizontalGroup((GroupLayout.Group)datasetParentPaneLayout.createParallelGroup(1).add(2, (Component)this.datasetCenteringPane, -1, 500, Short.MAX_VALUE).add((Component)this.datasetSeparator, -1, 500, Short.MAX_VALUE));
        datasetParentPaneLayout.setVerticalGroup((GroupLayout.Group)datasetParentPaneLayout.createParallelGroup(1).add((GroupLayout.Group)datasetParentPaneLayout.createSequentialGroup().add((Component)this.datasetCenteringPane, -2, -1, -2).add(8, 8, 8).add((Component)this.datasetSeparator, -2, -1, -2)));
        this.plotPane.add((Component)this.datasetParentPane, "North");
        this.cardPane.addTab("Main Options", this.plotPane);
        this.factorSeparator.setOrientation(1);
        GroupLayout subsetPaneLayout = new GroupLayout((Container)this.subsetPane);
        this.subsetPane.setLayout((LayoutManager)subsetPaneLayout);
        subsetPaneLayout.setHorizontalGroup((GroupLayout.Group)subsetPaneLayout.createParallelGroup(1).add((GroupLayout.Group)subsetPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.factorSelectionPane1, -2, 222, -2).addPreferredGap(1).add((Component)this.factorSeparator, -2, -1, -2).addPreferredGap(1).add((Component)this.factorSelectionPane2, -2, 228, -2).addContainerGap(-1, Short.MAX_VALUE)));
        subsetPaneLayout.setVerticalGroup((GroupLayout.Group)subsetPaneLayout.createParallelGroup(1).add(2, (Component)this.factorSeparator, -1, 262, Short.MAX_VALUE).add((GroupLayout.Group)subsetPaneLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.factorSelectionPane1, -1, 238, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)subsetPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.factorSelectionPane2, -1, 238, Short.MAX_VALUE).addContainerGap()));
        this.cardPane.addTab("Data Subsetting", this.subsetPane);
        this.getContentPane().add((Component)this.cardPane, "Center");
        this.buttonPane.setLayout(new FlowLayout(1, 10, 10));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPlotDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.cancelButton);
        this.submitButton.setText("Submit");
        this.submitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPlotDialog.this.submitButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.submitButton);
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataPlotDialog.this.helpButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.helpButton);
        this.getContentPane().add((Component)this.buttonPane, "South");
        this.pack();
    }

    protected void helpButtonAction() {
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        this.helpButtonAction();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    protected void submitButtonAction() {
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        this.submitButtonAction();
    }

    protected JTabbedPane getCardPane() {
        return this.cardPane;
    }

    protected void setCardPane(JTabbedPane cardPane) {
        this.cardPane = cardPane;
    }

    protected JPanel getPlotPane() {
        return this.plotPane;
    }

    protected void setPlotPane(JPanel plotPane) {
        this.plotPane = plotPane;
    }

    public DatasetPane getDatasetPane() {
        return this.datasetPane;
    }

    public void setDatasetPane(DatasetPane datasetPane) {
        this.datasetPane = datasetPane;
    }

    public FactorSubsetPane getFactorSelectionPane1() {
        return this.factorSelectionPane1;
    }

    public void setFactorSelectionPane1(FactorSubsetPane factorSelectionPane1) {
        this.factorSelectionPane1 = factorSelectionPane1;
    }

    public FactorSubsetPane getFactorSelectionPane2() {
        return this.factorSelectionPane2;
    }

    public void setFactorSelectionPane2(FactorSubsetPane factorSelectionPane2) {
        this.factorSelectionPane2 = factorSelectionPane2;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public void setHelpButton(JButton helpButton) {
        this.helpButton = helpButton;
    }

    public JButton getSubmitButton() {
        return this.submitButton;
    }

    public void setSubmitButton(JButton submitButton) {
        this.submitButton = submitButton;
    }
}

