% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.test.R
\name{population.test}
\alias{population.test}
\title{The one-sample population inference}
\usage{
population.test(popEst, alpha = 0.05, c0 = 0.1, MBT = 3000)
}
\arguments{
\item{popEst}{A \code{popEst} class object.}

\item{alpha}{significance level, default value is \code{0.05}.}

\item{c0}{threshold of the exceedance rate of the false discovery proportion (FDP),
default value is \code{0.1}.
The choice of \code{c0} depends on the empirical problem. A smaller value of \code{c0} will
reduce false positives, but it may also cost more false negatives.}

\item{MBT}{times of multiplier bootstrap, default value is \code{3000}.}
}
\value{
A \eqn{p*p} matrix with values 0 or 1.
}
\description{
Identify the nonzero partial correlations in one-sample population,
based on false discovery proportion controlling.
at \eqn{\alpha=0.05}, considering time dependence.
Input  data \eqn{Z} , contains values of p interested variables.
\cr
\cr
}
\examples{
## Quick example for the one-sample population inference
data(popsimA)
pc = population.est(popsimA)     # estimating partial correlation coefficients
Res = population.test(pc)        # conducting hypothesis test

## Inference on the first subject in population
Res1 = individual.test(pc$ind.est[[1]])

}
\references{
Qiu Y. and Zhou X. (2021).
Inference on multi-level partial correlations
based on multi-subject time series data,
\emph{Journal of the American Statistical Association}, 00, 1-15
}
\seealso{
\code{\link{individual.test}}.
}
