% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_DetectCenters.R
\name{BP_DetectCenters}
\alias{BP_DetectCenters}
\title{Detect the centers of an image}
\usage{
BP_DetectCenters(bone, analysis = 1, show.plot = TRUE)
}
\arguments{
\item{bone}{The bone image to be used}

\item{analysis}{The name or rank of analysis}

\item{show.plot}{should plot is shown ?}
}
\value{
The orignial bone object with a new attribute for centers
}
\description{
Detects the centers of an image. Note that this function must not be used with partial bone section.
}
\details{
BP_DetectCenters detects the centers of an image
}
\examples{
\dontrun{
# Not run:
library(BoneProfileR)
 bone <- BP_OpenImage()
 # or 
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone)
 bone <- BP_DetectForeground(bone=bone)
 bone <- BP_DetectCenters(bone=bone)
 plot(bone, type="mineralized", show.grid=FALSE)
 plot(bone, type="unmineralized", show.grid=FALSE)
 plot(bone, type="section", show.grid=FALSE)
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
