% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_FitMLCompactness.R
\name{BP_FitMLCompactness}
\alias{BP_FitMLCompactness}
\title{Estimation of the likelihood of a bone section}
\usage{
BP_FitMLCompactness(
  bone,
  fitted.parameters = c(P = 0.5, S = 0.05, Min = 0.001, Max = 0.999),
  fixed.parameters = c(K1 = 1, K2 = 1),
  twosteps = TRUE,
  replicates.CI = 10000,
  analysis = 1,
  silent = FALSE
)
}
\arguments{
\item{bone}{The bone image to be used}

\item{fitted.parameters}{Parameters of the model to be fitted}

\item{fixed.parameters}{Fixed parameters of the model}

\item{twosteps}{Does a 2-steps analysis be performed?}

\item{replicates.CI}{Number of replicates to estimate confidence interval}

\item{analysis}{Name or rank of analysis}

\item{silent}{Should information be shown?}
}
\value{
The -Ln L
}
\description{
Estimation of the model of compactness of a bone section.\cr
The two-steps analysis performs first a quasi-Newton method, then a Bayesian MCMC and finally again a quasi-Newton method. 
It generally ensures that global minimum is found. On the other hand, it doubles the time to complete.
}
\details{
BP_FitMLCompactness estimates likelihood of model of a bone section
}
\examples{
\dontrun{
# Not run:
library(BoneProfileR)
 bone <- BP_OpenImage()
 # or, to use the package imager to open a tiff image
 bone <- BP_OpenImage(ijtiff=TRUE)
library(BoneProfileR)
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone, analysis="logistic")
 bone <- BP_DetectForeground(bone=bone, analysis="logistic")
 bone <- BP_DetectCenters(bone=bone, analysis="logistic")
 bone <- BP_EstimateCompactness(bone, analysis="logistic")
 plot(bone, type="ontogenic", show.grid=FALSE)
 plot(bone, type="mineralized", show.grid=FALSE)
 plot(bone, type="unmineralized", show.grid=FALSE)
 plot(bone, type="section", show.grid=FALSE)
 bone <- BP_FitMLCompactness(bone, analysis="logistic", twosteps=TRUE)
 BP_GetFittedParameters(bone)
 plot(bone)
 plot(bone, type="observations")
 plot(bone, type="observations+model", analysis=1)
 bone <- BP_DuplicateAnalysis(bone, from="logistic", to="flexit")
 fittedpar <- BP_GetFittedParameters(bone, analysis="logistic")
 bone <- BP_DuplicateAnalysis(bone, from="logistic", to="flexit")
 BP_ListAnalyses(bone)
 bone <- BP_FitMLCompactness(bone, 
                fitted.parameters=c(fittedpar, K1=1, K2=1), 
                fixed.parameters=NULL, analysis="flexit", twosteps=TRUE)
 compare_AIC(Logistic=BP_GetFittedParameters(bone, analysis="logistic", alloptim=TRUE), 
             Flexit=BP_GetFittedParameters(bone, analysis="flexit", alloptim=TRUE))
 out4p <- plot(bone, type="observations+model", analysis="logistic")
 out6p <- plot(bone, type="observations+model", analysis="flexit")
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
