% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoltzMM.R
\name{fvbmHess}
\alias{fvbmHess}
\title{Hessian of the log-pseudolikelihood function for a fitted fully-visible Boltzmann machine.}
\usage{
fvbmHess(data, model)
}
\arguments{
\item{data}{An N by n matrix, where each of the N rows contains a length n string of spin variables  (i.e. each element is -1 or 1).}

\item{model}{List generated from \code{fitfvbm}.}
}
\value{
The n+choose(n,2) by n+choose(n,2) Hessian matrix, summed over the N rows of \code{data} and evaluated at the fitted parameter values provided in \code{model}. Each row (column) is a unique element of the bias vector and interaction matrix. The rows are arranged in lexicographical order with the bias elements first, followed by the interaction elements. For example, if n=3, the order would be bias[1], bias[2] bias[3], interaction[1,2], interaction[1,3], and interaction[2,3].
}
\description{
Computes the Hessian with respect to all unique parameter elements of the bias vector and interaction matrix of a fully-visible Boltzmann machine, for some random length n string of spin variables (i.e. each element is -1 or 1) and some fitted parameter values.
}
\examples{
# Generate num=1000 random strings of n=3 binary spin variables under bvec and Mmat.
num <- 1000
bvec <- c(0,0.5,0.25)
Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
data <- rfvbm(num,bvec,Mmat)
# Fit a fully visible Boltzmann machine to data, starting from parameters bvec and Mmat.
model <- fitfvbm(data,bvec,Mmat)
# Compute the Hessian matrix summed over all num rows of data.
fvbmHess(data,model)
}
\references{
H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
}
\author{
Andrew T. Jones and Hien D. Nguyen
}
