% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{allpfvbm}
\alias{allpfvbm}
\title{Probability mass function of a fully-visible Boltzmann machine evaluated for all possible vectors.}
\usage{
allpfvbm(bvec, Mmat)
}
\arguments{
\item{bvec}{Vector of length n containing real valued bias parameters.}

\item{Mmat}{Symmetric n by n matrix, with zeros along the diagonal, containing the interaction parameters.}
}
\value{
A vector of the probabilities of all 2^n binary spin vectors under a fully-visible Boltzmann machine with bias vector \code{bvec} and interaction matrix \code{Mmat}. Probabilities are reported in ascending order of the binary strings; i.e for n=2 the reporting order is (-1,1), (-1,1), (1,-1), and (1,1).
}
\description{
Compute the probability of all 2^n strings of n>1 binary spin variables (i.e. each element is -1 or 1) arising from a fully-visible Boltzmann machine with some specified bias vector and interaction matrix.
}
\examples{
# Compute the probability of every length n=3 binary spin vector under bvec and Mmat.
bvec <- c(0,0.5,0.25)
Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
allpfvbm(bvec,Mmat)
}
\references{
H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
}
\author{
Andrew T. Jones and Hien D. FNguyen
}
