% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeatmap.R
\name{plotHeatmap}
\alias{plotHeatmap}
\title{Plot a heatmap for selected genes}
\usage{
plotHeatmap(peakdet, exprmat, clustermembers = c())
}
\arguments{
\item{peakdet}{A list returned by the peakDetection function.}

\item{exprmat}{A numeric matrix with expression series data with variables as rownames.}

\item{clustermembers}{An optional character vector defining genes to be selected.}
}
\value{
This function does not return any value but generates a heatmap plot.
}
\description{
This function acts as a wrapper function for the heatmap.2 function of the gplots package and normalizes the
subjected expression matrix to the log2 of the mean expression of the gene across all time-points.
}
\examples{
# Example based on the heat-shock dataset
data(heat)
heat = as.matrix(heat)
# Define series
series <- c(37,40,41,42,43)
# Run the peak detection algorithm
peakdet <- peakDetection(heat, series, type ='rnaseq', actstrength = 1.5,
prominence = 1.3, minexpr = 5000)
# cluster exploration using kmeans with a maximum of 4 clusters to be assigned
clusters <- findClusters(peakdet, heat, maxclusters = 4, method = 'kmeans')
# Plot the heatmap for one of the clusters returned by the findClusters function
heatmap <- plotHeatmap(peakdet, heat, clustermembers = clusters$clustermembers[[1]])

}
\author{
David Lauenstein
}
