% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/901-calcDrugFPSim.R
\name{calcDrugFPSim}
\alias{calcDrugFPSim}
\title{Calculate Drug Molecule Similarity Derived by Molecular Fingerprints}
\usage{
calcDrugFPSim(fp1, fp2, fptype = c("compact", "complete"),
  metric = c("tanimoto", "euclidean", "cosine", "dice", "hamming"))
}
\arguments{
\item{fp1}{The first molecule's fingerprints, 
could be extracted by \code{extractDrugMACCS()}, 
\code{extractDrugMACCSComplete()} etc.}

\item{fp2}{The second molecule's fingerprints.}

\item{fptype}{The fingerprint type, must be one of \code{"compact"} or 
\code{"complete"}.}

\item{metric}{The similarity metric, 
one of \code{"tanimoto"}, \code{"euclidean"}, \code{"cosine"}, 
\code{"dice"} and \code{"hamming"}.}
}
\value{
The numeric similarity value.
}
\description{
Calculate Drug Molecule Similarity Derived by Molecular Fingerprints
}
\details{
This function calculate drug molecule fingerprints similarity.
Define \code{a} as the features of object A, \code{b} is the 
features of object B, \code{c} is the number of common features to A and B:
\itemize{
\item Tanimoto: aka Jaccard - \eqn{c/a+b+c}
\item Euclidean: \eqn{\sqrt(a + b)}
\item Dice: aka Sorensen, Czekanowski, Hodgkin-Richards - 
\eqn{c/0.5[(a+c) + (b+c)]}
\item Cosine: aka Ochiai, Carbo - \eqn{c/\sqrt((a + c)(b + c))}
\item Hamming: aka Manhattan, taxi-cab, city-block distance - \eqn{(a + b)}
}
}
\examples{
\donttest{
mols = readMolFromSDF(system.file('compseq/tyrphostin.sdf', package = 'BioMedR'))

fp1 = extrDrugEstate(mols[[1]])
fp2 = extrDrugEstate(mols[[2]])
calcDrugFPSim(fp1, fp2, fptype = 'compact', metric = 'tanimoto')}

}
\references{
Gasteiger, Johann, and Thomas Engel, eds. 
Chemoinformatics. Wiley.com, 2006.
}
\author{
Min-feng Zhu <\email{wind2zhu@163.com}>, 
        Nan Xiao <\url{http://r2s.name}>
}
\keyword{Cosine}
\keyword{Dice}
\keyword{Drug}
\keyword{Euclidean}
\keyword{Hamming}
\keyword{Similarity}
\keyword{Tanimoto}
\keyword{calcDrugFPSim}
