% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BioCircos.R
\name{BioCircosSNPTrack}
\alias{BioCircosSNPTrack}
\title{Create a track with SNPs to be added to a BioCircos tracklist}
\usage{
BioCircosSNPTrack(trackname, chromosomes, positions, values,
  colors = "#40B9D4", labels = "", size = 2, shape = "circle",
  opacities = 1, maxRadius = 0.9, minRadius = 0.5, range = 0, ...)
}
\arguments{
\item{trackname}{The name of the new track.}

\item{chromosomes}{A vector containing the chromosomes on which each SNP are found.
Values should match the chromosome names given in the genome parameter of the BioCircos function.}

\item{positions}{A vector containing the coordinates on which each SNP are found.
Values should be inferior to the chromosome lengths given in the genome parameter of the BioCircos function.}

\item{values}{A vector of numerical values associated with each SNPs, used to determine the 
radial coordinates of each point on the visualization.}

\item{colors}{The colors for each point. Can be a RColorBrewer palette name used to
generate one color per point, or a character object or vector of character objects stating RGB values in hexadecimal
format or base R colors. If the vector is shorter than the number of points, values will be repeated.}

\item{labels}{One or multiple character objects to label each point.}

\item{size}{The size of each point.}

\item{shape}{Shape of the points. Can be "circle" or "rect".}

\item{opacities}{One or multiple opacity values for the points, between 0 and 1.}

\item{minRadius, maxRadius}{Where the track should begin and end, in proportion of the inner radius of the plot.}

\item{range}{Vector of values to be mapped to the minimum and maximum radii of the track.
Default to 0, mapping the minimal and maximal values input in the values parameter.}

\item{...}{Ignored}
}
\description{
SNPs are defined by genomic coordinates and associated with a numerical value
}
\examples{
BioCircos(BioCircosSNPTrack('SNPTrack', chromosomes = 1:3, positions = 1e+7*2:4, 
  values = 1:3, colors = "Accent", labels = c('A', 'B', 'C')) + BioCircosBackgroundTrack('BGTrack'))

}
