#' BifactorIndicesCalculator: A package for computing statistical indices relevant to bifactor measurement models.
#'
#' The BifactorIndicesCalculator package provides functions use to compute
#' indices described in Rodriguez et al. (2016) for confirmatory or exploratory models.
#'
#' @section BifactorIndicesCalculator functions:
#' The BifactorIndicesCalculator package includes helper functions that can compute the various
#' indices from Rodriguez et al. (2016) for fitted \pkg{lavaan} or \pkg{mirt} objects using
#' \code{\link{bifactorIndices}} and \code{Mplus} output files using
#' \code{\link{bifactorIndicesMplus}}. For users of other software and those
#' interested, a matrix of standardized factor loadings can also be input to
#' \code{\link{bifactorIndices}}.
#'
#' Calculation of bifactor indices for exploratory bifactor models can also be accomplished
#' using \code{\link{bifactorIndices_expl}} for exploratory models fit using \pkg{psych}
#' or using \code{\link{bifactorIndicesMplus_expl}} for exploratory models fit using
#' \code{Mplus}. For ESEM models fit using \code{Mplus}, please use \code{\link{bifactorIndicesMplus_ESEM}}
#'
#' @section References:
#' Rodriguez, A., Reise, S. P., & Haviland, M. G. (2016).
#' Evaluating bifactor models: calculating and interpreting
#' statistical indices. \emph{Psychological Methods, 21}(2), 137.
#'
#' @docType package
#' @name BifactorIndicesCalculator

NULL
