% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{rows_full1_in_BC}
\alias{rows_full1_in_BC}
\title{Finding BC's with specific rows which only 1's in the BC.}
\usage{
rows_full1_in_BC(matrix, bicresult, rows)
}
\arguments{
\item{matrix}{The binary input matrix.}

\item{bicresult}{A \code{Biclust} result. (e.g. The return object from \code{bibit} or \code{bibit2})}

\item{rows}{A vector containing containing the row numbers which should be in the bicluster.}
}
\value{
A matrix containing the biclusters in the columns and the row, column and size dimensions on the rows.
}
\description{
Simple function which scans a \code{Biclust} result and returns which biclusters contain all rows given in the \code{rows} parameter,
but only if these rows only contain 1's in the bicluster. This can be particularly helpful after having added articial row-pairs with a pattern of interest. 
With this function you can retrieve the biclusters that grew from these pairs from all the discovered biclusters.
}
\examples{
\dontrun{
data <- matrix(sample(c(0,1),100*100,replace=TRUE,prob=c(0.9,0.1)),nrow=100,ncol=100)
data[1:10,1:10] <- 1 # BC1
data[11:20,11:20] <- 1 # BC2
data[21:30,21:30] <- 1 # BC3

extra_rows <- rep(0,100)
extra_rows[11:25] <- 1

data <- rbind(data,rbind(extra_rows,extra_rows)) 
rownames(data) <- NULL

result <- bibit2(data,minr=2,minc=2,noise=0.2)

rows_full1_in_BC(matrix=data,bicresult=result,rows=c(101,102))

}
}
\author{
Ewoud De Troyer
}

