/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.ComplexSubstitutionModel;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import java.util.Arrays;

public class MutationDeathModel
extends ComplexSubstitutionModel {
    private SubstitutionModel CTMCModel;
    private Parameter delParameter = null;
    protected double[] trMatrix;
    private Parameter baseSubModelFreq;
    private Parameter thisSubModelFreq;
    private Parameter mutationRate;
    private double[] baseModelMatrix;

    public MutationDeathModel(Parameter parameter, DataType dataType, SubstitutionModel substitutionModel, FrequencyModel frequencyModel, Parameter parameter2) {
        super("mutationDeathModel", dataType, frequencyModel, (Parameter)null);
        int n;
        this.CTMCModel = substitutionModel;
        this.stateCount = frequencyModel.getFrequencyCount();
        this.delParameter = parameter;
        this.dataType = dataType;
        this.mutationRate = parameter2;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(parameter2);
        if (substitutionModel != null) {
            this.addModel(substitutionModel.getFrequencyModel());
            this.addModel(substitutionModel);
        }
        this.trMatrix = new double[(this.stateCount - 1) * (this.stateCount - 1)];
        this.baseSubModelFreq = this.CTMCModel != null ? this.CTMCModel.getFrequencyModel().getFrequencyParameter() : new Parameter.Default(new double[]{1.0});
        this.thisSubModelFreq = this.getFrequencyModel().getFrequencyParameter();
        double d = 0.0;
        for (n = 0; n < this.baseSubModelFreq.getDimension(); ++n) {
            double d2 = this.thisSubModelFreq.getParameterValue(n);
            d += d2;
            this.baseSubModelFreq.setParameterValue(n, d2);
        }
        for (n = 0; n < this.baseSubModelFreq.getDimension(); ++n) {
            this.baseSubModelFreq.setParameterValue(n, this.baseSubModelFreq.getParameterValue(n) / d);
        }
        this.thisSubModelFreq.setParameterValue(this.thisSubModelFreq.getDimension() - 1, 0.0);
        this.copyFrequencies();
        this.frequenciesChanged();
        this.ratesChanged();
        if (this.CTMCModel != null) {
            n = this.CTMCModel.getDataType().getStateCount();
            this.baseModelMatrix = new double[n * n];
        } else {
            this.baseModelMatrix = new double[1];
        }
        this.setDoNormalization(false);
    }

    public Parameter getDeathParameter() {
        return this.delParameter;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (object == this.baseSubModelFreq) {
            this.copyFrequencies();
            this.fireModelChanged(object, n);
        } else if (model == this.CTMCModel) {
            this.fireModelChanged(object, n);
        }
    }

    private void copyFrequencies() {
        for (int i = 0; i < this.baseSubModelFreq.getDimension(); ++i) {
            this.thisSubModelFreq.setParameterValueQuietly(i, this.baseSubModelFreq.getParameterValue(i));
        }
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected void setupQMatrix(double[] dArray, double[] dArray2, double[][] dArray3) {
        int n;
        for (n = 0; n < dArray3.length; ++n) {
            Arrays.fill(dArray3[n], 0.0);
        }
        n = 1;
        if (this.CTMCModel != null) {
            this.CTMCModel.getInfinitesimalMatrix(this.baseModelMatrix);
            n = this.CTMCModel.getDataType().getStateCount();
        }
        double d = this.delParameter.getParameterValue(0);
        double d2 = 2.0 * this.mutationRate.getParameterValue(0);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[i][j] = this.baseModelMatrix[n2] - d;
                ++n2;
            }
            dArray3[i][n] = d;
        }
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
    }
}

