% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation_Randomisepatientstotrt.R
\name{AdaptiveRandomisation}
\alias{AdaptiveRandomisation}
\title{AdaptiveRandomisation}
\usage{
AdaptiveRandomisation(
  Fixratio,
  rand.algo,
  K,
  n.new,
  randomprob,
  treatmentindex,
  groupwise.response.probs,
  group,
  armleft,
  max.deviation,
  trend_add_or_multip,
  trend.function,
  trend.effect,
  ns,
  Fixratiocontrol
)
}
\arguments{
\item{Fixratio}{A indicator TRUE/FALSE}

\item{rand.algo}{Randomisation algorithm: "Coin": Biased coin; "Urn": Urn method}

\item{K}{Total number of arms at the beginning}

\item{n.new}{The cohort size}

\item{randomprob}{A named vector of randomisation probability to each arm}

\item{treatmentindex}{The vector of treatment arm index excluding the control arm whose index is 0}

\item{groupwise.response.probs}{A matrix of response probability of each arm}

\item{group}{The current stage}

\item{armleft}{The number of treatment left in the platform (>2)}

\item{max.deviation}{Tuning parameter of using urn randomisation method.}

\item{trend_add_or_multip}{How time trend affects the true response probability: "add" or "mult"}

\item{trend.function}{The function returns time trend effect regarding to different time trend pattern}

\item{trend.effect}{The strength of time trend effect as a parameter in trend.function()}

\item{ns}{A vector of accumulated number of patient at each stage}

\item{Fixratiocontrol}{A numeric value indicating the weight of control in randomisation.
Eg. 1 means equal randomisation, 2 means thw number of patients allocated to control is twice as large as other treatment arm.}
}
\value{
A list of patient allocation and patient outcome
nstage: A vector of the number of patients allocated to each arm
ystage: A vector of the patients outcome after treating with each arm
znew: A vector of treatment index assigned to each patient in the current cohort
ynew: A vector of outcome index record for each patient after treatment in the current cohort
}
\description{
This is a function doing the randomisation process. This Function generates the Sequence for patient allocation to each arm, patient outcomes.
}
\examples{
AdaptiveRandomisation(
Fixratio = FALSE,
rand.algo = "Urn",
K = 2,
n.new = 30,
randomprob = matrix(c(0.5, 0.5), ncol = 2, dimnames = list(c(),c("1","2"))),
treatmentindex = 1,
groupwise.response.probs = matrix(rep(c(0.4, 0.4), 5), byrow = TRUE, ncol = 2, nrow = 5),
group = 1,
armleft = 2,
max.deviation = 3,
trend_add_or_multip = "mult",
trend.function = function(ns, group, i, trend.effect) {delta = 0; return(delta)},
trend.effect = c(0, 0),
ns = c(30, 60, 90, 120, 150),
Fixratiocontrol = NA)

AdaptiveRandomisation(
Fixratio = TRUE,
rand.algo = "Urn",
K = 4,
n.new = 30,
randomprob = NA,
treatmentindex = c(1,3),
groupwise.response.probs = matrix(rep(c(0.4, 0.4,0.4, 0.4), 5), byrow = TRUE, ncol = 4, nrow = 5),
group = 1,
armleft = 3,
max.deviation = 3,
trend_add_or_multip = "mult",
trend.function = function(ns, group, i, trend.effect) {delta = 0; return(delta)},
trend.effect = c(0, 0),
ns = c(30, 60, 90, 120, 150),
Fixratiocontrol = 1)

}
\references{
Mass weighted urn design—a new randomization algorithm for unequal allocations. Zhao, Wenle. Contemporary clinical trials 43 (2015): 209-216.
}
\author{
Ziyan Wang
}
