// Generated by rstantools.  Do not edit by hand.

/*
    BayesianPlatformDesignTimeTrend is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    BayesianPlatformDesignTimeTrend is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with BayesianPlatformDesignTimeTrend.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_randomeffect_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'randomeffect', line 10, column 2 to column 14)",
                                                      " (in 'randomeffect', line 11, column 2 to column 17)",
                                                      " (in 'randomeffect', line 12, column 2 to column 25)",
                                                      " (in 'randomeffect', line 13, column 2 to column 22)",
                                                      " (in 'randomeffect', line 17, column 2 to column 26)",
                                                      " (in 'randomeffect', line 18, column 2 to column 24)",
                                                      " (in 'randomeffect', line 19, column 2 to column 28)",
                                                      " (in 'randomeffect', line 20, column 2 to column 38)",
                                                      " (in 'randomeffect', line 21, column 2 to column 93)",
                                                      " (in 'randomeffect', line 22, column 2 to column 27)",
                                                      " (in 'randomeffect', line 28, column 11 to column 12)",
                                                      " (in 'randomeffect', line 28, column 4 to column 17)",
                                                      " (in 'randomeffect', line 30, column 6 to column 85)",
                                                      " (in 'randomeffect', line 29, column 19 to line 31, column 5)",
                                                      " (in 'randomeffect', line 29, column 4 to line 31, column 5)",
                                                      " (in 'randomeffect', line 32, column 4 to column 31)",
                                                      " (in 'randomeffect', line 27, column 17 to line 33, column 3)",
                                                      " (in 'randomeffect', line 27, column 2 to line 33, column 3)",
                                                      " (in 'randomeffect', line 2, column 2 to column 17)",
                                                      " (in 'randomeffect', line 3, column 2 to column 17)",
                                                      " (in 'randomeffect', line 4, column 2 to column 24)",
                                                      " (in 'randomeffect', line 5, column 8 to column 9)",
                                                      " (in 'randomeffect', line 5, column 2 to column 35)",
                                                      " (in 'randomeffect', line 6, column 8 to column 9)",
                                                      " (in 'randomeffect', line 6, column 2 to column 35)",
                                                      " (in 'randomeffect', line 7, column 8 to column 9)",
                                                      " (in 'randomeffect', line 7, column 2 to column 30)",
                                                      " (in 'randomeffect', line 11, column 9 to column 10)",
                                                      " (in 'randomeffect', line 12, column 9 to column 17)"};
#include <stan_meta_header.hpp>
class model_randomeffect final : public model_base_crtp<model_randomeffect> {
private:
  int N;
  int K;
  int groupmax;
  std::vector<int> X;
  std::vector<int> Y;
  std::vector<int> group;
 
public:
  ~model_randomeffect() { }
  
  inline std::string model_name() const final { return "model_randomeffect"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_randomeffect(stan::io::var_context& context__,
                     unsigned int random_seed__ = 0,
                     std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_randomeffect_namespace::model_randomeffect";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 19;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 19;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 19;
      current_statement__ = 19;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 20;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 20;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 20;
      current_statement__ = 20;
      check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 21;
      context__.validate_dims("data initialization","groupmax","int",
          context__.to_vec());
      groupmax = std::numeric_limits<int>::min();
      
      current_statement__ = 21;
      groupmax = context__.vals_i("groupmax")[(1 - 1)];
      current_statement__ = 21;
      current_statement__ = 21;
      check_greater_or_equal(function__, "groupmax", groupmax, 1);
      current_statement__ = 22;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 23;
      context__.validate_dims("data initialization","X","int",
          context__.to_vec(N));
      X = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 23;
      assign(X, nil_index_list(), context__.vals_i("X"),
        "assigning variable X");
      current_statement__ = 23;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 23;
        current_statement__ = 23;
        check_greater_or_equal(function__, "X[sym1__]", X[(sym1__ - 1)], 1);}
      current_statement__ = 23;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 23;
        current_statement__ = 23;
        check_less_or_equal(function__, "X[sym1__]", X[(sym1__ - 1)], K);}
      current_statement__ = 24;
      validate_non_negative_index("Y", "N", N);
      current_statement__ = 25;
      context__.validate_dims("data initialization","Y","int",
          context__.to_vec(N));
      Y = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 25;
      assign(Y, nil_index_list(), context__.vals_i("Y"),
        "assigning variable Y");
      current_statement__ = 25;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 25;
        current_statement__ = 25;
        check_greater_or_equal(function__, "Y[sym1__]", Y[(sym1__ - 1)], 0);}
      current_statement__ = 25;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 25;
        current_statement__ = 25;
        check_less_or_equal(function__, "Y[sym1__]", Y[(sym1__ - 1)], 1);}
      current_statement__ = 26;
      validate_non_negative_index("group", "N", N);
      current_statement__ = 27;
      context__.validate_dims("data initialization","group","int",
          context__.to_vec(N));
      group = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 27;
      assign(group, nil_index_list(), context__.vals_i("group"),
        "assigning variable group");
      current_statement__ = 27;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 27;
        current_statement__ = 27;
        check_greater_or_equal(function__, "group[sym1__]",
                               group[(sym1__ - 1)], 1);}
      current_statement__ = 28;
      validate_non_negative_index("beta", "K", K);
      current_statement__ = 29;
      validate_non_negative_index("alpha", "groupmax", groupmax);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += 1;
      num_params_r__ += K;
      num_params_r__ += groupmax;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_randomeffect_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      local_scalar_t__ beta_0;
      beta_0 = DUMMY_VAR__;
      
      current_statement__ = 1;
      beta_0 = in__.scalar();
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 2;
      beta = in__.vector(K);
      Eigen::Matrix<local_scalar_t__, -1, 1> alpha;
      alpha = Eigen::Matrix<local_scalar_t__, -1, 1>(groupmax);
      stan::math::fill(alpha, DUMMY_VAR__);
      
      current_statement__ = 3;
      alpha = in__.vector(groupmax);
      local_scalar_t__ gamma;
      gamma = DUMMY_VAR__;
      
      current_statement__ = 4;
      gamma = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        gamma = stan::math::lb_constrain(gamma, 0, lp__);
      } else {
        current_statement__ = 4;
        gamma = stan::math::lb_constrain(gamma, 0);
      }
      {
        current_statement__ = 5;
        lp_accum__.add(normal_lpdf<propto__>(beta_0, 0, 1.8));
        current_statement__ = 6;
        lp_accum__.add(normal_lpdf<propto__>(beta, 0, 1.8));
        current_statement__ = 7;
        lp_accum__.add(normal_lpdf<propto__>(alpha[(1 - 1)], 0, 0.01));
        current_statement__ = 8;
        lp_accum__.add(
          normal_lpdf<propto__>(alpha[(2 - 1)], 0,
            stan::math::sqrt((1 / gamma))));
        current_statement__ = 9;
        lp_accum__.add(
          normal_lpdf<propto__>(
            rvalue(alpha,
              cons_list(index_min_max(3, groupmax), nil_index_list()),
              "alpha"),
            subtract(
              multiply(2,
                rvalue(alpha,
                  cons_list(index_min_max(2, (groupmax - 1)),
                    nil_index_list()), "alpha")),
              rvalue(alpha,
                cons_list(index_min_max(1, (groupmax - 2)), nil_index_list()),
                "alpha")), stan::math::sqrt((1 / gamma))));
        current_statement__ = 10;
        lp_accum__.add(gamma_lpdf<propto__>(gamma, 0.1, 0.01));
        current_statement__ = 18;
        for (int n = 1; n <= N; ++n) {
          current_statement__ = 11;
          validate_non_negative_index("pi", "K", K);
          Eigen::Matrix<local_scalar_t__, -1, 1> pi;
          pi = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
          stan::math::fill(pi, DUMMY_VAR__);
          
          current_statement__ = 15;
          for (int k = 1; k <= K; ++k) {
            current_statement__ = 13;
            assign(pi, cons_list(index_uni(k), nil_index_list()),
              inv_logit(
                ((beta_0 + (beta[(k - 1)] * logical_eq(X[(n - 1)], k))) +
                  alpha[(((groupmax - group[(n - 1)]) + 1) - 1)])),
              "assigning variable pi");}
          current_statement__ = 16;
          lp_accum__.add(
            bernoulli_lpmf<propto__>(Y[(n - 1)], pi[(X[(n - 1)] - 1)]));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_randomeffect_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      double beta_0;
      beta_0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      beta_0 = in__.scalar();
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      beta = in__.vector(K);
      Eigen::Matrix<double, -1, 1> alpha;
      alpha = Eigen::Matrix<double, -1, 1>(groupmax);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      alpha = in__.vector(groupmax);
      double gamma;
      gamma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      gamma = in__.scalar();
      current_statement__ = 4;
      gamma = stan::math::lb_constrain(gamma, 0);
      vars__.emplace_back(beta_0);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= groupmax; ++sym1__) {
        vars__.emplace_back(alpha[(sym1__ - 1)]);}
      vars__.emplace_back(gamma);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      double beta_0;
      beta_0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      beta_0 = context__.vals_r("beta_0")[(1 - 1)];
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 2;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> alpha;
      alpha = Eigen::Matrix<double, -1, 1>(groupmax);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 3;
        assign(alpha_flat__, nil_index_list(), context__.vals_r("alpha"),
          "assigning variable alpha_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= groupmax; ++sym1__) {
          current_statement__ = 3;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            alpha_flat__[(pos__ - 1)], "assigning variable alpha");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      double gamma;
      gamma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      gamma = context__.vals_r("gamma")[(1 - 1)];
      double gamma_free__;
      gamma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      gamma_free__ = stan::math::lb_free(gamma, 0);
      vars__.emplace_back(beta_0);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= groupmax; ++sym1__) {
        vars__.emplace_back(alpha[(sym1__ - 1)]);}
      vars__.emplace_back(gamma_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("beta_0");
    names__.emplace_back("beta");
    names__.emplace_back("alpha");
    names__.emplace_back("gamma");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(groupmax)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "beta_0");
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= groupmax; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "gamma");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "beta_0");
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= groupmax; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "gamma");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta_0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << groupmax << "},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"beta_0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << groupmax << "},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_randomeffect_namespace::model_randomeffect;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_randomeffect_namespace::profiles__;
}
#endif
#endif
