% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawCurves.R
\name{DrawCurves_MRMC_pairwise_col}
\alias{DrawCurves_MRMC_pairwise_col}
\title{Draw the FROC  curves with Colour}
\usage{
DrawCurves_MRMC_pairwise_col(
  StanS4class,
  modalityID,
  readerID,
  type = 1,
  color_is_changed_by_each_reader = FALSE,
  new.imaging.device = TRUE,
  DrawFROCcurve = TRUE,
  DrawAFROCcurve = FALSE,
  DrawCFPCTP = TRUE,
  Draw.Flexible.upper_y = TRUE,
  Draw.Flexible.lower_y = TRUE,
  summary = TRUE
)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{stanfit}.
This \R object is a fitted model object
 as a return value of the function \code{\link{fit_Bayesian_FROC}()}.

It can be passed to \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{modalityID}{This is a vector indicating modalityID whose component is natural namber.}

\item{readerID}{This is a vector indicating readerID whose component is natural namber.}

\item{type}{An integer, for the color of background and etc.}

\item{color_is_changed_by_each_reader}{A logical, if \code{TRUE}, then the FROC curves, AFROC curves, and FPF, TPF are colored accordingly by each reader. The aim of FROC analysis is to compare the modality and not reader, so the default value is false, and curves and FPF and TPF are colored by each modalities.}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{DrawFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether  the FROC curve  is to be drawn.}

\item{DrawAFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the  AFROC curve is to be drawn.}

\item{DrawCFPCTP}{Logical: \code{TRUE} of \code{FALSE}. Whether  the CFP and CTP points are to be drawn. CFP: Cumulative false positive per lesion (or image) which is also called False Positive Fraction (FPF). CTP Cumulative True Positive per lesion  which is also called True Positive Fraction (TPF)..}

\item{Draw.Flexible.upper_y}{Logical, that is \code{TRUE} or \code{FALSE}. Whether or not the upper bounds of vertical axis are determined automatically.}

\item{Draw.Flexible.lower_y}{Logical, that is \code{TRUE} or \code{FALSE}. Whether or not the lower bounds of vertical axis are determined automatically.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary. If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}
}
\description{
Draw an FROC  curves and an AFROC curves for user's specified modality and user's specified reader.
Using this function \strong{repeatedly}, we can draw the different reader and modality in a  \strong{same} plane simultaneously.
So, we can visualize the difference of modality (reader).
}
