% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_square_goodness_of_fit.R
\name{hits_false_alarms_creator_from_thresholds}
\alias{hits_false_alarms_creator_from_thresholds}
\title{Hits and False Alarms Creator}
\usage{
hits_false_alarms_creator_from_thresholds(replicate.datset = 3,
  ModifiedPoisson = FALSE, mean.truth = 0.6, sd.truth = 5.3,
  z.truth = c(-0.8, 0.7, 2.38), NL = 259, NI = 57, summary = TRUE,
  initial.seed = 12345)
}
\arguments{
\item{replicate.datset}{A Number indicate that how many you replicate dataset from user's specified dataset.}

\item{ModifiedPoisson}{This is dichotomous, that is \code{TRUE} or \code{FALSE}. If
\code{ModifiedPoisson = TRUE}, then Poisson rate of false alarm are \code{per lesion},
and if \code{ModifiedPoisson = FALSE}, then Poisson rate of false alarm are \code{per image}.
To know detail, refer the author's paper in which I explained per image and per lesion.}

\item{mean.truth}{This is a parameter of the latent Gaussian assumption for the noise distribution.}

\item{sd.truth}{This is a parameter of the latent Gaussian assumption for the noise distribution.}

\item{z.truth}{This is a parameter of the latent Gaussian assumption for the noise distribution.}

\item{NL}{Number of Lesions.}

\item{NI}{Number of Images.}

\item{summary}{TRUE or FALSE. If TRUE then summary and estimates are printed in the R console. If FALSE, the output is minimal.}

\item{initial.seed}{Replicated datasets are created using a continuous sequence of seeds and its initial seed is specified by this argument. For example, if you choose initial.seed =12300, then the replicated datasets are created from using  the sequence of seeds: 12301,12302,12303,12304,…}
}
\value{
Datasets Including Hits and False Alarms
}
\description{
From the parameter of the bi-normal assumptions, hits and false alarms are generated.
}
\details{
From the fixed parameters of bi-normal assumptions, we replicate data, that is, we draw the data from the distributions whose parameters are known. Especially, we interest the hits and false alarms since the number of images, lesions and confidence level is same for all replications. So, it is sufficient to check the hits and false alarms.
}
\examples{

 \donttest{
#================The first example======================================
#      Replication of Data from Fixed ( specified) Parameters.

 a <- hits_false_alarms_creator_from_thresholds(replicate.datset = 1)

#  Extract the first replicated dataset:

 a[[1]]$NL
 a[[1]]$NI
 a[[1]]$f
 a[[1]]$h
 a[[1]]$C


#================The second example======================================
#      Replication of Data from Fixed ( specified) Parameters.

 b <- hits_false_alarms_creator_from_thresholds(replicate.datset = 2)


#  Extract the first replicated dataset:

 b[[1]]$NL
 b[[1]]$NI
 b[[1]]$f
 b[[1]]$h
 b[[1]]$C


#  Extract the second replicated dataset:

 b[[2]]$NL
 b[[2]]$NI
 b[[2]]$f
 b[[2]]$h
 b[[2]]$C


#================The Third example======================================
#      Replication of Data from Fixed ( specified) Parameters.


 c <- hits_false_alarms_creator_from_thresholds(replicate.datset = 3)


#  Extract the first replicated dataset:

 c[[1]]$NL
 c[[1]]$NI
 c[[1]]$f
 c[[1]]$h
 c[[1]]$C


#  Extract the second replicated dataset:

 c[[2]]$NL
 c[[2]]$NI
 c[[2]]$f
 c[[2]]$h
 c[[2]]$C

#  Extract the third replicated dataset:

 c[[3]]$NL
 c[[3]]$NI
 c[[3]]$f
 c[[3]]$h
 c[[3]]$C



}# dottest

}
