% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{make_mask}
\alias{make_mask}
\title{Mask out invalid data}
\usage{
make_mask(data, meanTol = 1e-06, varTol = 1e-06, verbose = TRUE)
}
\arguments{
\item{data}{A list of sessions, where each session is a list with elements
\code{BOLD}, \code{design}, and optionally \code{nuisance}. See
\code{?is.BfMRI.sess} for details.}

\item{meanTol, varTol}{Tolerance for mean and variance of each data location.
Locations which do not meet these thresholds are masked out of the analysis.
Defaults: \code{1e-6}.}

\item{verbose}{Print messages counting how many locations are removed?
Default: \code{TRUE}.}
}
\value{
A logical vector indicating locations that are valid across all sessions.
}
\description{
Mask out data locations that are invalid (missing data, low mean, or low
variance) for any session.
}
\examples{
nT <- 30
nV <- 400
BOLD1 <- matrix(rnorm(nT*nV), nrow=nT)
BOLD1[,seq(30,50)] <- NA
BOLD2 <- matrix(rnorm(nT*nV), nrow=nT)
BOLD2[,65] <- BOLD2[,65] / 1e10
data <- list(sess1=list(BOLD=BOLD1, design=NULL), sess2=list(BOLD=BOLD2, design=NULL))
make_mask(data)

}
