% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesTreePrior.R
\name{BayesTreePriorNotOrthogonal}
\alias{BayesTreePriorNotOrthogonal}
\title{Simulation of the tree prior in the general case (Case #4).}
\usage{
BayesTreePriorNotOrthogonal(alpha, beta, X, n_iter = 500, minpart = 1,
  pvars = NULL, MIA = FALSE, missingdummy = FALSE)
}
\arguments{
\item{alpha}{base parameter of the tree prior, \eqn{\alpha \in [0,1)}.}

\item{beta}{power parameter of the tree prior, \eqn{\beta \geq 0}.}

\item{X}{data.frame of the design matrix.}

\item{n_iter}{number of trees to generate, \eqn{n_{iter}>0}.}

\item{minpart}{the minimum number of bottom nodes required in one of the child to be able to split, \eqn{minpart>0}.}

\item{pvars}{vector of probabilities for the choices of variables to split (Will automatically be normalized so that the sum equal to 1). It must be twice as large as the number of variables when \eqn{missingdummy} is TRUE.}

\item{MIA}{set to TRUE if you want Missing Incorporated in Attributes (MIA) imputation to be used.}

\item{missingdummy}{set to TRUE if you have dummy coded the NAs.}
}
\value{
Returns a list containing, in the following order: the mean number of bottom nodes, the standard deviation of the number of bottom nodes, the mean of the depth, the standard deviation of the depth and a data.frame of vectors \eqn{(b_i,d_i)}, where \eqn{b_i} is the number of bottom nodes and \eqn{d_i} is the depth of the \eqn{i}th generated tree (\eqn{i=1, \ldots ,n_{iter}}).
}
\description{
Generate \eqn{n_{iter}} trees from the prior distribution in the general case (Case #4).
}
\examples{
if (requireNamespace("MASS", quietly = TRUE)) {
    x1 = MASS::mcycle$times
    x1[sample(1:length(x1), 20)] <- NA
    x2= MASS::mcycle$accel
    x2[sample(1:length(x2), 20)] <- NA
    X = cbind(x1, x2)
    results1 = BayesTreePriorNotOrthogonal(.95,.5, data.frame(X), minpart=5)
    X_dummies = is.na(X) + 0
    results2 = BayesTreePriorNotOrthogonal(.95,.5, data.frame(cbind(X,X_dummies)), minpart=5, 
    MIA=TRUE, missingdummy=TRUE)
}
}
\seealso{
\code{\link{BayesTreePriorOrthogonalInf}}, \code{\link{BayesTreePriorOrthogonal}}
}

