% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BFs.R
\name{BFsSMD}
\alias{BFsSMD}
\title{Sceptical Bayes factor for SMD effect sizes}
\usage{
BFsSMD(
  to,
  no,
  n1o = no,
  n2o = no,
  tr,
  nr,
  n1r = nr,
  n2r = nr,
  type = c("two.sample", "one.sample", "paired")
)
}
\arguments{
\item{to}{\eqn{t}-statistic from the original study}

\item{no}{Sample size of the original study (per group)}

\item{n1o}{Sample size in group 1 of the original study (only required for
two-sample \eqn{t}-test with unequal group sizes)}

\item{n2o}{Sample size in group 2 of the original study (only specify if
unequal group sizes)}

\item{tr}{\eqn{t}-statistic from the replication study}

\item{nr}{Sample size of the replication study (per group)}

\item{n1r}{Sample size in group 1 of the replication study (only required for
two-sample \eqn{t}-test with unequal group sizes)}

\item{n2r}{Sample size in group 2 of the replication study (only required for
two-sample \eqn{t}-test with unequal group sizes)}

\item{type}{Type of \eqn{t}-test associated with \eqn{t}-statistic. Can be
\code{"two.sample"}, \code{"one.sample"}, \code{"paired"}. Defaults to \code{"two.sample"}.}
}
\value{
The sceptical Bayes factor \eqn{\mathrm{BF}_{\mathrm{S}}}{BF_S}.
\eqn{\mathrm{BF}_{\mathrm{S}} < 1}{BF_S < 1} indicates replication
success, the smaller the value of \eqn{\mathrm{BF}_{\mathrm{S}}}{BF_S}
the higher the degree of replication success. It is possible that the
result of the replication is so inconclusive that replication success
cannot be established at any level. In this case, the sceptical Bayes
factor does not exist and the function returns \code{NaN}.
}
\description{
Computes the sceptical Bayes factor for standardized mean
difference (SMD) effect sizes
}
\details{
This function computes the sceptical Bayes factor for standardized
mean difference (SMD) effect sizes using an exact \emph{t}-likelihood for the
data instead of the normal approximation used in \code{\link{BFs}} (for
details, see Section 4 in Pawel and Held, 2022). Data from both studies
are summarized by \eqn{t}-statistics and sample sizes. The following
types of \eqn{t}-tests are accepted:
\itemize{
\item Two-sample \eqn{t}-test where the SMD represents the standardized
mean difference between two group means (assuming equal variances in
both groups).
\item One-sample \eqn{t}-test where the SMD represents the standardized
mean difference to the null value.
\item Paired \eqn{t}-test where the SMD represents the standardized mean
difference score.
}
}
\examples{
data("SSRPexact")
morewedge2010 <- subset(SSRPexact, study == "Morewedge et al. (2010), Science")
with(morewedge2010,
     BFsSMD(to = to, n1o = n1o, n2o = n2o, tr = tr, n1r = n1r, n2r = n2r))

}
\references{
Pawel, S. and Held, L. (2022). The sceptical Bayes factor for the
assessment of replication success. Journal of the Royal Statistical
Society Series B: Statistical Methodology, 84(3): 879-911.
\doi{10.1111/rssb.12491}
}
\seealso{
\code{\link{BFs}}, \code{\link{BFslogOR}}
}
\author{
Samuel Pawel
}
