% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_point.R
\name{fixed_point}
\alias{fixed_point}
\title{Modal fixed-point algorithm}
\usage{
fixed_point(
  mcmc,
  data,
  pars_names,
  tol_x = sd(data)/10,
  tol_conv = 1e-08,
  show_plot = F
)
}
\arguments{
\item{mcmc}{Vector of estimated mixture parameters.}

\item{data}{Vector of observations used for estimating the mixture.}

\item{pars_names}{Names of the mixture parameters; first element should 
correspond to the mixture proportions; second to the mean; third to the 
standard deviation.}

\item{tol_x}{Tolerance parameter for distance in-between modes; default is sd(data)/10; if two modes are closer than \code{tol_x}, only the first estimated mode is kept.}

\item{tol_conv}{Tolerance parameter for convergence of the algorithm; default is 1e-8.}

\item{show_plot}{If true show the data and estimated modes; default is false.}
}
\value{
Vector of estimated modes.
}
\description{
Algorithm for estimating modes in mixture of Normal distributions from Carreira-Perpinan (2000).
}
\details{
This algorithm returns the local maxima of the mixture
\deqn{p(x) = \sum_{k=1}^{K}\pi_k p_k(x),}
where \eqn{p_k} comes from the Normal family.
Following Carreira-perpinan (2000), a mode \eqn{x} is found by iterating the two steps:
\deqn{(i) \quad p(k|x^{(n)}) = \frac{\pi_k p_k(x^{(n)})}{p(x^{(n)})},}
\deqn{(ii) \quad x^{(n+1)} = f(x^{(n)}),}
with
\deqn{f(x) = (\sum_k p(k|x) \sigma_k)^{-1}\sum_k p(k|x) \sigma_k \mu_k,}
until convergence, that is, until \eqn{abs(x^{(n+1)}-x^{(n)})< \text{tol}_\text{conv}},
where \eqn{\text{tol}_\text{conv}} is an argument with default value \eqn{1e-8}.
Following Carreira-perpinan (2000), the algorithm is started at each component location.
Separately, it is necessary to identify identical modes which diverge only up to
a small value. By default modes which are closer
than \eqn{sd(y)/10} are merged; this tolerance value can be controlled with the argument
\code{tol_x}.
}
\examples{
mu = c(0,5)
sigma = c(1,2)
p = c(0.5,0.5)

data = c(rnorm(p[1]*100, mu[1], sigma[1]), rnorm(p[2]*100, mu[2], sigma[2]))
params = c(eta = p, mu = mu, sigma = sigma)
pars_names = c("eta", "mu", "sigma")
modes = fixed_point(params, data, pars_names)

}
\references{
\insertRef{carreira-perpinan_mode-finding_2000}{BayesMultiMode}
}
