% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{likelihood.feedforward_tdist}
\alias{likelihood.feedforward_tdist}
\title{Use  a t-Distribution likelihood for a Feedforward network}
\usage{
likelihood.feedforward_tdist(chain, sig_prior, nu = 30)
}
\arguments{
\item{chain}{Network structure obtained using \code{link{Chain}}}

\item{sig_prior}{A prior distribution for sigma defined using
\code{\link{Gamma}}, \code{link{InverGamma}},
\code{\link{Truncated}}, \code{\link{Normal}}}

\item{nu}{DF of TDist}
}
\value{
see \code{\link{likelihood.feedforward_normal}}
}
\description{
This creates a likelihood of the form
\deqn{\frac{y_i - net(x_i)}{\sigma} \sim T_\nu\;\forall i=1,...,N}
 where the \eqn{x_i} is fed through the network in the standard feedforward way.
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_tdist(net, Gamma(2.0, 0.5), nu=8)
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  BNN.totparams(bnn)
}

}
