% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mcmc.R
\name{BayesFBHborrow}
\alias{BayesFBHborrow}
\title{BayesFBHborrow: Run MCMC for a piecewise exponential model}
\usage{
BayesFBHborrow(
  data,
  data_hist = NULL,
  tuning_parameters,
  initial_values,
  hyperparameters,
  lambda_hyperparameters,
  iter,
  warmup_iter,
  refresh,
  verbose,
  max_grid
)
}
\arguments{
\item{data}{data.frame containing atleast three vectors of "tte" (time-to-event)
and "event" (censoring), and covariates "X_i" (where i should be a number/
indicator of the covariate)}

\item{data_hist}{data.frame containing atleast three vectors of "tte" 
 (time-to-event) and "event" (censoring), with the option of adding covariates
 named "X_0_i" (where i should be a number/
indicator of the covariate), for historical
 data}

\item{tuning_parameters}{list of "cprop_beta", "cprop_beta_0", "alpha", "Jmax",
and "pi_b"}

\item{initial_values}{list containing the initial values of c("J", "s_r",
"mu", "sigma2", "tau", "lambda_0", "lambda", "beta_0", "beta") (optional)}

\item{hyperparameters}{list containing the hyperparameters c("a_tau", "b_tau",
 "c_tau", "d_tau","type", "p_0", "a_sigma", "b_sigma", "Jmax", "clam_smooth",
 "cprop_beta", "phi", "pi_b"). Default is list("a_tau" = 1,"b_tau" = 1,"c_tau" = 1,
"d_tau" = 0.001, "type" = "mix", "p_0" = 0.5, "a_sigma" = 2, "b_sigma" = 2,
"Jmax" = 20, "clam_smooth" = 0.8, "cprop_beta" = 0.3, "phi" = 3, "pi_b" = 0.5)}

\item{lambda_hyperparameters}{contains two (three) hyperparameters (a, b (,alpha))
used for the update of lambda and lambda_0. alpha is the power parameter when 
sampling for lambda (effects how much is borrowed)}

\item{iter}{number of iterations for MCMC sampler}

\item{warmup_iter}{number of warmup iterations (burn-in) for MCMC sampler.}

\item{refresh}{number of iterations between printed screen updates}

\item{verbose}{TRUE (default), choice of output, if TRUE will output 
intermittent results into console}

\item{max_grid}{grids size for the smoothed baseline hazard}
}
\value{
list of samples for both fixed (can be found in $out_fixed) and 
multidimensional parameters (lambda, lambda_0, s, tau)
}
\description{
Main function of the BayesFBHborrow package. This generic function 
calls the correct MCMC sampler for time-to-event Bayesian borrowing.
}
\examples{
set.seed(123)
# Load the example data and write your initial values and hyper parameters
data(piecewise_exp_cc, package = "BayesFBHborrow")
data(piecewise_exp_hist, package = "BayesFBHborrow")

# Set your hyperparameters and tuning parameters
hyper <-  list("a_tau" = 1, 
               "b_tau" = 0.001,
               "c_tau" = 1,
               "d_tau" = 1, 
               "type" = "all",
               "p_0" = 0.5, 
               "a_sigma" = 2,
               "b_sigma" = 2,
               "clam_smooth" = 0.5,
               "phi" = 3)

tuning_parameters <- list("Jmax" = 5,
                          "pi_b" = 0.5,
                          "cprop_beta" = 0.5,
                          "alpha" = 0.4)
                          
# Set initial values to default
out <- BayesFBHborrow(piecewise_exp_cc, piecewise_exp_hist, tuning_parameters,
                      initial_values = NULL, hyper, iter = 5, warmup_iter = 1)

# Create a summary of the output
# summary(out, estimator = "out_fixed")

# Plot some of the estimates
# Do beta (trace), s (hist) and lambda (matrix)
trace <- plot(out, 1:5, estimator = "beta_1", type = "trace")
hist <- plot(out, estimator = "J", type = "hist")
smoothed_baseline_hazard <- plot(out, 1:2000, estimator = "out_slam", 
                                 type = "matrix")
}
