% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BayesCTDesigncode.R
\name{plot_table}
\alias{plot_table}
\title{Plot Data from Two Arm Bayesian Clinical Trial Simulation.}
\usage{
plot_table(bayes_ctd_array, measure = "power", tab_type = "WX|YZ",
  smooth = FALSE, plot_out = TRUE, subj_per_arm_val = NULL,
  a0_val = NULL, effect_val = NULL, rand_control_diff_val = NULL,
  span = 0.75, degree = 2, family = "gaussian", title = NULL,
  ylim = NULL)
}
\arguments{
\item{bayes_ctd_array}{Name of object of class \code{bayes_ctd_array} containing
data from clinical trial simulation.}

\item{measure}{Must be equal to \code{power}, \code{est}, \code{var}, \code{bias},
or \code{mse}.  Default is \code{power}.  Case does not matter.}

\item{tab_type}{A character string that must equal \code{WX|YZ}, \code{WY|XZ},
\code{WZ|XY}, \code{XY|WZ}, \code{XZ|WY}, \code{YZ|WX}, \code{ZX|WY}, \code{XW|YZ},
\code{YW|XZ}, \code{YX|WZ}, \code{ZW|XY}, \code{ZX|WY}, \code{ZY|WX} when
\code{bayes_ctd_array} is generated by \code{historic_sim()}.  Default is
\code{WX|YZ}.  When \code{bayes_ctd_array} is generated by \code{simple_sim()},
\code{tab_type} is ignored.}

\item{smooth}{A true/false parameter indicating whether smoothed results
should be plotted. Note, smoothing of simulation results requires the length of
\code{subj_per_arm_val} or \code{a0_val} or \code{effect_val} or
\code{rand_control_diff_val}, whichever populates the x-axis on the graph to
contain enough elements to justify the smoothing.  No checking occurs to
determine if enough elements are present to justify smoothing.  Default is
\code{FALSE}.}

\item{plot_out}{A true/false parameter indicating whether the plot should be
produced.  This parameter is useful if the user only wants a table of smoothed
values.  Default is \code{TRUE}.}

\item{subj_per_arm_val}{Must be non-missing, if \code{bayes_ctd_array} is generated
by \code{historic_sim()} and sample size is being held constant.
If \code{bayes_ctd_array} is generated by \code{historic_sim()} and sample size
is being held constant, \code{subj_per_arm_val} must equal a value submitted
to \code{historic_sim()} within the \code{subj_per_arm} parameter.  When
\code{bayes_ctd_array} is generated by \code{simple_sim()}, \code{subj_per_arm_val}
is ignored.}

\item{a0_val}{Must be non-missing, if \code{bayes_ctd_array} is generated
by \code{historic_sim()} and a0, the power prior parameter, is being held
constant.  If \code{bayes_ctd_array} is generated by \code{historic_sim()} and
a0 is being held constant, \code{a0_val} must equal a value submitted
to \code{historic_sim()} within the \code{a0_val} parameter.  When
\code{bayes_ctd_array} is generated by \code{simple_sim()}, \code{a0_val} is
ignored.}

\item{effect_val}{Must be non-missing, if \code{bayes_ctd_array} is generated
by \code{historic_sim()} and effect is being held constant.  If
\code{bayes_ctd_array} is generated by \code{historic_sim()} and effect is being
held constant, \code{effect_val} must equal a value submitted to
\code{historic_sim()} within the \code{effect_vals} parameter.  When
\code{bayes_ctd_array} is generated by \code{simple_sim()}, \code{effect_val} is
ignored.}

\item{rand_control_diff_val}{Must be non-missing, if \code{bayes_ctd_array} is
generated by \code{historic_sim()} and differences between randomized
and historical controls are being held constant.  If \code{bayes_ctd_array}
is generated by \code{historic_sim()} and control differences are being
held constant, \code{rand_control_diff_val} must equal a value submitted to
\code{historic_sim()} within the \code{rand_control_diff} parameter.  When
\code{bayes_ctd_array} is generated by \code{simple_sim()},
\code{rand_control_diff_val} is ignored.}

\item{span}{The \code{span} parameter value for a call \code{loess()}.  Default is 0.75.  If
\code{span} is a single number, then that value will be used to smooth the data in all
columns of the table being plotted.  If \code{span} is a vector, then it must have length
equal to the number of columns being plotted.}

\item{degree}{The \code{degree} parameter value for a call \code{loess()}.  Default is 2.
The value of \code{degree} will be used for all columns being plotted.}

\item{family}{The \code{family} parameter value for a call \code{loess()}.  Default is
"\code{gaussian}".  The value of \code{family} will be used for all columns being plotted.}

\item{title}{Title for the plot.}

\item{ylim}{Lower and upper limits for y-axis of plot.}
}
\value{
\code{plot_table()} returns a plot for a two dimensional array of simulation
  results.  If \code{smooth} is \code{TRUE}, then the plot is based on a smoothed
  version of the simulation results. If \code{smooth} is \code{FALSE}, then the plot
  is based on the raw data from the simulation results.  What actually is plotted
  depends on the value of \code{measure}.  If \code{plot_out} is \code{FALSE}, the
  plot is not created.  This option is useful when the user wants a table of smoothed
  simulation results but does not want the plot. Smoothing of simulation results
  requires the length of \code{subj_per_arm_val} or \code{a0_val} or \code{effect_val}
  or \code{rand_control_diff_val}, whichever populates the x-axis on the graph to
  contain enough elements to justify the smoothing.  No checking occurs to
  determine if enough elements are present to justify smoothing.
}
\description{
\code{plot_table()} takes an S3 object of class \code{bayes_ctd_array}, and creates
a line plot from a one or two dimensional slice of the data generated by a clinical
trial simulation using \code{historic_sim()} or \code{simple_sim()}.   This method
has been replaced with \code{plot()}.  The method \code{plot_table()} has been
retained for continuity with original release of \code{BayesCTDesign}.The plotted
results can be smoothed or unsmoothed.
}
\details{
If the object of class \code{bayes_ctd_array} is created by \code{historic_sim()},
the function \code{plot_table()} allows the user to create line plots of user-specified
1- or 2- dimensional slices of the simulation results based on slicing code
described below. If the object of class \code{bayes_ctd_array} is created by
\code{simple_sim()}, a basic plot of characteristic by sample size and effect is created.

If the object of class \code{bayes_ctd_array} is created by \code{simple_sim()}, then
all four trial characteristics (\code{subj_per_arm_val}, \code{a0_vals},
\code{effect_val}, and \code{rand_control_diff_val}) can be ignored as can the
parameter defining what type of plot to create through the parameter \code{tab_type}.
A call to \code{plot_table()} will require the user to specify a measure (power, est,
var, bias, or mse).

If the object of class \code{bayes_ctd_array} is created by \code{historic_sim()},
when calling \code{plot_table()} the user must specify a measure to plot
(power, est, var, bias, or mse) and may be required to specify a plot type through
the \code{tab_type} parameter.  A plot type, \code{tab_type}, will be required if
3 of the 4 trial characteristics are equal to a vector of 2 or more values.  This
plot type specification uses the letters W, X, Y, and Z.  The letter W represents
the subject per arm dimension.  The letter X represents the a0 dimension.  The
letter Y represents the effect dimension.  The letter Z represents the control
difference dimension.  To plot a slice of the 4-dimensional array, these letters
are put into an AB|CD pattern just like in \code{print()} or \code{print_table()}.
The two letters to the right of the vertical bar define which variables are held
constant.  The two letters to the left of the vertical bar define which variables
are going to show up in the plot.  The first letter defines the x-axis variable
and the second letter defines the stratification variable.  The result is a plot
of power, estimate, variance, bias, or mse by the trial characteristic represented
by the first letter.  On this plot, one line will be created for each value of the
trial characteristic represented by the second letter.  For example if tab_type
equals \code{WX|YZ}, then effect and control differences will be held constant,
while sample size will be represented along the horizontal axis and a0 values will
be represented by separate lines.  The actual values that are plotted on the y-axis
depend on what measure is requested in the parameter \code{measure}.

\itemize{
  \item \code{tab_type='WX|YZ'}, Sample Size by a0
  \item \code{tab_type='WY|XZ'}, Sample Size by Effect
  \item \code{tab_type='WZ|XY'}, Sample Size by Control Differences
  \item \code{tab_type='XY|WZ'}, a0 by Effect
  \item \code{tab_type='XZ|WY'}, a0 by Control Differences
  \item \code{tab_type='YZ|WX'}, Effect by Control Differences
  \item \code{tab_type='ZX|WY'}, Control Differences by a0
  \item \code{tab_type='XW|YZ'}, a0 by Sample Size
  \item \code{tab_type='YW|XZ'}, Effect by Sample Size
  \item \code{tab_type='YX|WZ'}, Effect by a0
  \item \code{tab_type='ZW|XY'}, Control Differences by Sample Size
  \item \code{tab_type='ZY|WX'}, Control Differences by Effect
}
It is very important to populate the values of \code{subj_per_arm_val},
\code{a0_val}, \code{effect_val}, and \code{rand_control_diff_val} correctly given
the value of tab_type, when the object of class \code{bayes_ctd_array} is created by
\code{historic_sim()} and at least 3 of the four parameters have more than one
value.  On, the other hand, if 2 or more of the four parameters have only one value,
then \code{subj_per_arm_val}, \code{a0_vals}, \code{effect_val},
\code{rand_control_diff_val}, as well as \code{tab_type} can be ignored.  If the last
two letters are \code{YZ}, then \code{effect_val} and \code{rand_control_diff_val}
must be populated.  If the last two letters are \code{XZ}, then \code{a0_val} and
\code{rand_control_diff_val} must be populated.  If the last two letters are \code{XY},
then \code{a0_val} and \code{effect_val} must be populated.  If the last two letters
are \code{WZ}, then \code{sample_val} and \code{rand_control_diff_val} must be
populated.  If the last two letters are \code{WY}, then \code{sample_size_val} and
\code{effect_val} must be populated.  If the last two letters are \code{WX}, then
\code{sample_size_val} and \code{a0_val} must be populated.

If the object of class \code{bayes_ctd_array} is created by \code{simple_sim()}, the
parameters \code{tab_type}, \code{subj_per_arm_val}, \code{a0_val}, \code{effect_val},
and \code{rand_control_diff_val} are ignored.
}
\examples{
\donttest{
#Run a Weibull simulation, using simple_sim().
#For meaningful results, trial_reps needs to be much larger than 2.
weibull_test <- simple_sim(trial_reps = 2, outcome_type = "weibull",
                           subj_per_arm = c(50, 100, 150, 200),
                           effect_vals = c(0.6, 1),
                           control_parms = c(2.82487,3), time_vec = NULL,
                           censor_value = NULL, alpha = 0.05,
                           get_var = TRUE, get_bias = TRUE, get_mse = TRUE,
                           seedval=123, quietly=TRUE)

#Create a plot of the power simulation results.
plot_table(bayes_ctd_array=weibull_test, measure="power", tab_type=NULL,
           smooth=FALSE, plot_out=TRUE, subj_per_arm_val=NULL, a0_val=NULL,
           effect_val=NULL, rand_control_diff_val=NULL)
#Create a plot of the hazard ratio simulation results.
plot_table(bayes_ctd_array=weibull_test, measure="est", tab_type=NULL,
           smooth=FALSE, plot_out=TRUE, subj_per_arm_val=NULL, a0_val=NULL,
           effect_val=NULL, rand_control_diff_val=NULL)
#Create a plot of the hazard ratio variance simulation results.
plot_table(bayes_ctd_array=weibull_test, measure="var", tab_type=NULL,
           smooth=FALSE, plot_out=TRUE, subj_per_arm_val=NULL, a0_val=NULL,
           effect_val=NULL, rand_control_diff_val=NULL)
#Create a plot of the hazard ratio bias simulation results.
plot_table(bayes_ctd_array=weibull_test, measure="bias", tab_type=NULL,
           smooth=FALSE, plot_out=TRUE, subj_per_arm_val=NULL, a0_val=NULL,
           effect_val=NULL, rand_control_diff_val=NULL)
#Create a plot of the hazard ratio mse simulation results.
plot_table(bayes_ctd_array=weibull_test, measure="mse", tab_type=NULL,
           smooth=FALSE, plot_out=TRUE, subj_per_arm_val=NULL, a0_val=NULL,
           effect_val=NULL, rand_control_diff_val=NULL)
}

\donttest{
#Run a second Weibull simulation, using simple_sim() and smooth the plot.
#For meaningful results, trial_reps needs to be larger than 100.
weibull_test2 <- simple_sim(trial_reps = 100, outcome_type = "weibull",
                            subj_per_arm = c(50, 75, 100, 125, 150, 175, 200, 225, 250),
                            effect_vals = c(0.6, 1, 1.4),
                            control_parms = c(2.82487,3), time_vec = NULL,
                            censor_value = NULL, alpha = 0.05, get_var = TRUE,
                            get_bias = TRUE, get_mse = TRUE, seedval=123,
                            quietly=TRUE)

#Create a plot of the power simulation results.
plot_table(bayes_ctd_array=weibull_test2, measure="power", tab_type=NULL,
           smooth=TRUE, plot_out=TRUE, subj_per_arm_val=NULL, a0_val=NULL,
           effect_val=NULL, rand_control_diff_val=NULL, span=c(1,1,1))
}

\donttest{
#Run a third weibull simulation, using historic_sim().
#Note: historic_sim() can take a while to run.
#Generate a sample of historical data for use in example.
set.seed(2250)
SampleHistData <- genweibulldata(sample_size=60, scale1=2.82487,
                                 hazard_ratio=0.6, common_shape=3,
                                 censor_value=3)
histdata <- subset(SampleHistData, subset=(treatment==0))
histdata$id <- histdata$id+10000

#For meaningful results, trial_reps needs to be larger than 100.
weibull_test3 <- historic_sim(trial_reps = 100, outcome_type = "weibull",
                              subj_per_arm = c(50, 100, 150, 200, 250),
                              a0_vals = c(0, 0.33, 0.67, 1),
                              effect_vals = c(0.6, 1, 1.4),
                              rand_control_diff = c(0.8, 1, 1.2),
                              hist_control_data = histdata, time_vec = NULL,
                              censor_value = 3, alpha = 0.05, get_var = TRUE,
                              get_bias = TRUE, get_mse = TRUE, seedval=123,
                              quietly=TRUE)

#Create a plot of the power simulation results.
plot_table(bayes_ctd_array=weibull_test3, measure="power", tab_type="WX|YZ",
           smooth=FALSE, plot_out=TRUE, effect_val=0.6,
           rand_control_diff_val=1.0)
}

\donttest{
#Run a Gaussian simulation, using historic_sim()
#Generate a sample of historical Gaussian data for use in example.
set.seed(2250)
samplehistdata <- gengaussiandata(sample_size=60, mu1=25, mean_diff=0, common_sd=3)
histdata <- subset(samplehistdata, subset=(treatment==0))
histdata$id <- histdata$id+10000

#For meaningful results, trial_reps needs to be larger than 100.
gaussian_test <- historic_sim(trial_reps = 100, outcome_type = "gaussian",
                             subj_per_arm = c(150),
                             a0_vals = c(1.0),
                             effect_vals = c(0.15),
                             rand_control_diff = c(-4.0,-3.5,-3.0,-2.5,-2.0,
                                                   -1.5,-1.0,-0.5,0,0.5,1.0),
                             hist_control_data = histdata, time_vec = NULL,
                             censor_value = 3, alpha = 0.05, get_var = TRUE,
                             get_bias = TRUE, get_mse = TRUE, seedval=123,
                             quietly=TRUE)

#Create a plot of the power simulation results.
plot_table(bayes_ctd_array=gaussian_test, measure="power", tab_type=NULL,
          smooth=TRUE, plot_out=TRUE, effect_val=NULL,
          rand_control_diff_val=NULL)
}

\donttest{
#Generate a sample of historical pwe data for use in example.
set.seed(2250)
nvalHC <- 60
time.vec <- c(0.3,0.9,1.5,2.1,2.4)
lambdaHC.vec <- c(0.19,0.35,0.56,0.47,0.38,0.34)
censor.value <- 3

SampleHistData <- genpwedata(nvalHC, lambdaHC.vec, 1.0, time.vec, censor.value)
histdata <- subset(SampleHistData, subset=(treatment==0))
histdata$indicator <- 2 #If set to 2, then historical controls will be collapsed with
#randomized controls, when time_vec is re-considered and
#potentially restructured.  If set to 1, then historical
#controls will be treated as a separated cohort when
#time_vec is being assessed for restructuring.
histdata$id <- histdata$id+10000

#Run a pwe simulation, using historic_sim().
#For meaningful results, trial_reps needs to be larger than 100.
pwe_test <- historic_sim(trial_reps = 100, outcome_type = "pwe",
                        subj_per_arm = c(25,50,75,100,125,150,175,200,225,250),
                        a0_vals = c(1.0),
                        effect_vals = c(0.6),
                        rand_control_diff = c(1.8),
                        hist_control_data = histdata, time_vec = time.vec,
                        censor_value = 3, alpha = 0.05, get_var = TRUE,
                        get_bias = TRUE, get_mse = TRUE, seedval=123,
                        quietly=TRUE)

#Create a plot of the power simulation results.
plot_table(bayes_ctd_array=pwe_test, measure="power", tab_type=NULL,
          smooth=TRUE, plot_out=TRUE, effect_val=NULL,
          rand_control_diff_val=NULL)
}

}
