% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.meta.c.R
\name{model.meta.c}
\alias{model.meta.c}
\title{Bayesian hierarchical model code for CACE meta-analysis with complete compliance data}
\usage{
model.meta.c(random.effects = list(), re.values = list())
}
\arguments{
\item{random.effects}{a list of logical values indicating whether random effects are included in the model.
The list should contain the assignment for these parameters only: \code{delta.n} (\eqn{\delta_{in}}), 
\code{delta.a} (\eqn{\delta_{ia}}), \code{delta.u} (\eqn{\delta_{iu}}), \code{delta.v} (\eqn{\delta_{iv}}), 
\code{delta.s} (\eqn{\delta_{is}}), \code{delta.b} (\eqn{\delta_{ib}}), \code{cor}. The list should be in the
form of \code{list(delta.a = FALSE, cor = FALSE, ...)}. By default, this
is an empty list, and all parameters are default to \code{TRUE}. Parameters that are not listed in the list
are assumed to be \code{TRUE}. Note that \eqn{\rho} (\code{cor}) can only be included when both \eqn{\delta_{in}} 
(\code{delta.n}) and \eqn{\delta_{ia}} (\code{delta.a}) are set to \code{TRUE}. Otherwise, a warning 
occurs and the model continues running by forcing \code{delta.n = TRUE} and \code{delta.a = TRUE}.}

\item{re.values}{a list of parameter values for the random effects. It should contain the assignment for these
parameters only: \code{alpha.n.m} and \code{alpha.n.s}, which refer to the mean and standard deviation used
in the normal distribution estimation of \code{alpha.n}, as well as \code{alpha.a.m}, \code{alpha.a.s}, 
\code{alpha.s.m}, \code{alpha.s.s}, \code{alpha.b.m}, \code{alpha.b.s}, \code{alpha.u.m}, \code{alpha.u.s},
\code{alpha.v.m}, \code{alpha.v.s}. It also contains the shape and rate parameters of the gamma distributions
of the standard deviation variable of \code{delta.n}, \code{delta.a}, \code{delta.u}, \code{delta.v}
\code{delta.s}, \code{delta.b}. The shape parameters are named as \code{tau.n.h} and \code{tau.a.h}, for example,
and the rate parameters are named as \code{tau.n.r} and \code{tau.a.r}. You do not need to specify the shape and
rate parameters if the corresponding random effect is set to \code{FALSE} in \code{random.effects}, since they will
not be used anyways. By default, \code{re.values} is an empty list, and all the mean are set to \code{0}, and 
\code{alpha.n.s = alpha.a.s = 0.16}, and \code{alpha.s.s = alpha.b.s = alpha.u.s = alpha.v.s = 0.25},
and the shape and rate parameters are default to \code{2}.}
}
\value{
It returns a model string
}
\description{
This function generates part of the model code for meta-analysis 
when the dataset has complete compliance information for all studies, 
as described in Section 2.2, "the Bayesian hierarchical model" of the package manuscript.
This function will be called internally if user uses the \code{cace.meta.c} function.
}
\examples{
# use default settings
model.string <- model.meta.c()
}
