% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_BayLumFiles.R
\name{write_BayLumFiles}
\alias{write_BayLumFiles}
\title{Write BayLum .csv-files}
\usage{
write_BayLumFiles(
  folder,
  SampleNames = "Sample_1",
  BinPerSample = rep(1, length(SampleNames)),
  SubSampleNames = NULL,
  DiscPos = NULL,
  DRenv = 1,
  DRenv.error = 0.04,
  DRsource = 0.1,
  DRsource.error = 0.002,
  signal.integral.min = 6,
  signal.integral.max = 10,
  background.integral.min = 346,
  background.integral.max = 395,
  inflatePercent = 0.025,
  nbOfLastCycleToRemove = 2
)
}
\arguments{
\item{folder}{\link{character} (\emph{required}*): The name of the main folder in which all subsequent BayLum files and folders will be located. This could be a path to an already existing folder, or the path/name of a folder to be created.}

\item{SampleNames}{\link{character} (\emph{required}): Vector of sample names.}

\item{BinPerSample}{\link{numeric} (\emph{with default}): Vector of numbers indicating the number of .bin-files per sample.}

\item{SubSampleNames}{\link{character} (\emph{optional}): Vector of names to give each subfolder within a sample when the number of .bin-files in a sample counts more than one. If omitted or NULL, the subfolders are named by the subfolder count number.}

\item{DiscPos}{\link{numeric} (\emph{with default}): List of data frames with each data frame having one or two columns to identify aliquots/grains to be included in the analysis. The first column corresponds to the position number, and the second column corresponds to the grain number. If the data frame has only one column, a Disc.csv will be written. If the data.frame has two columns, a DiscPos.csv will be written. The length of the list should be the number of .bin-files included.}

\item{DRenv}{\link{numeric} (\emph{with default}): Vector where \code{DRenv[i]} corresponds to environmental dose rate for \code{.bin-file[i]}. Length should be one or the number of .bin-files included in the analysis.}

\item{DRenv.error}{\link{numeric} (\emph{with default}): Vector where \code{DRenv.error[i]} corresponds to environmental dose rate error for \code{.bin-file[i]}. Length should be one or the number of .bin-files included in the analysis.}

\item{DRsource}{\link{numeric} (\emph{with default}): Vector where \code{DRsource[i]} corresponds to source dose rate for \code{.bin-file[i]}. Length should be one or the number of .bin-files included in the analysis.}

\item{DRsource.error}{\link{numeric} (\emph{with default}): Vector where \code{DRsource.error[i]} corresponds to source dose rate error for \code{.bin-file[i]}. Length should be one or the number of .bin-files included in the analysis.}

\item{signal.integral.min}{\link{numeric} (\emph{with default}): Vector where \code{signal.integral.min[i]} corresponds to the channel number where the OSL signal should be summed from for\code{bin-file[i]} Length should be one or the number of .bin-files included in the analysis.}

\item{signal.integral.max}{\link{numeric} (\emph{with default}): Vector where \code{signal.integral.max[i]} corresponds to the channel number where the OSL signal should be summed from to for \code{bin-file[i]} Length should be one or the number of .bin-files included in the analysis.}

\item{background.integral.min}{\link{numeric} (\emph{with default}): Vector where \code{background.integral.min[i]} corresponds to the channel number where the OSL background signal should be summed from for\code{bin-file[i]} Length should be one or the number of .bin-files included in the analysis.}

\item{background.integral.max}{\link{numeric} (\emph{with default}): Vector where \code{background.integral.max[i]} corresponds to the channel number where the OSL background signal should be summed to for \code{.bin-file[i]}. Length should be one or the number of .bin-files included in the analysis.}

\item{inflatePercent}{\link{numeric} (\emph{with default}): Vector where \code{inflatePercent[i]} corresponds to uncertainty due to instrumental reproducibility to\code{bin-file[i]} Length should be one or the number of .bin-files included in the analysis.}

\item{nbOfLastCycleToRemove}{\link{numeric} (\emph{with default}): Vector where \code{nbOfLastCycleToRemove[i]} corresponds to the number of regeneration points to remove in analysis for \code{bin-file[i]} Length should be one or the number of .bin-files included in the analysis.}
}
\value{
The function returns nothing, but writes the folder structure.
}
\description{
This function allows the user to write all .csv files expected by
\link{Generate_DataFile} and \link{Generate_DataFile_MG}. Unlike \link{create_FolderTemplates},
this function makes it possible to write .csv files with all information directly from R.
No further modification of .csv files are required. The purpose of this function is (i) to reduce tedious manual editing of .csv-files and the errors that result
(ii) to introduce an easy way to review information inside .csv-files (by revisiting code rather than opening individual .csv-files) and (iii) to streamline folder
and file creation when preparing data to run BayLum's modelling functions. Note: the user will still need to move the appropriate .bin-files into all the sample folders.
}
\section{Function version}{
 0.1.0
}

\examples{
# example samples
SampleNames <- c("OSL-1-MG","OSL-2-SG")

# number of .bin-files for each sample
BinPerSample <- c(1,3)

# List of data.frames of accepted aliquot/grain to be included
# in the analysis for each .bin-file.
DiscPos <- list(
data.frame("position" = 1:48),
data.frame("position" = c(1,1,1,1), "grain" = c(4,67,92,99)),
data.frame("position" = c(2,2,2,2), "grain" = c(7,13,41,72)),
data.frame("position" = c(3,3,3,3), "grain" = c(7,52,67,88)))

# example 1: write to disk (all together)
write_BayLumFiles(
folder = paste(tempdir(),"new_BayLum_folder",sep = "/"),
SampleNames = SampleNames,
BinPerSample = BinPerSample,
DiscPos = DiscPos,
DRenv = c(1.75, 1.52, 1.52, 1.52),
DRenv.error = c(0.04, 0.03, 0.03, 0.03),
DRsource = c(0.2075, 0.1501, 0.1501, 0.1501),
DRsource.error = c(0.0010, 0.0008, 0.0008, 0.0008))

# example 2: write to disk (by sample)
write_BayLumFiles(
folder = paste(tempdir(),"new_BayLum_folder",sep = "/"),
SampleNames = "OSL-1-MG",
BinPerSample = 1,
DiscPos = DiscPos[[1]],
DRenv = 1.75,
DRenv.error = 0.04,
DRsource = 0.2075,
DRsource.error = 0.0010)

write_BayLumFiles(
folder = paste(tempdir(),"new_BayLum_folder",sep = "/"),
SampleNames = "OSL-2-SG",
BinPerSample = 3,
DiscPos = DiscPos[2:4],
DRenv = 1.75,
DRenv.error = 0.04,
DRsource = 0.2075,
DRsource.error = 0.0010)

}
\seealso{
\link{Generate_DataFile}, \link{Generate_DataFile_MG}
}
\author{
Frederik Baumgarten, RadPhys, DTU Physics, Technical University of Denmark (Denmark)
} 

\section{How to cite}{
Baumgarten, F.H., 2023. write_BayLumFiles(): Write BayLum .csv-files. Function version 0.1.0. In: Christophe, C., Philippe, A., Kreutzer, S., Guérin, G., Baumgarten, F.H., 2023. BayLum: Chronological Bayesian Models Integrating Optically Stimulated. R package version 0.3.1. https://CRAN.r-project.org/package=BayLum
}

\keyword{IO}
\keyword{datagen}
